/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.utils;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TreeDetector {
    public static BlockPos getNearestGround(Level worldIn, BlockPos pos) {
        while (pos.m_123342_() > worldIn.m_141937_() && worldIn.m_8055_(pos.m_7495_()).m_247087_()) {
            pos = pos.m_7495_();
        }
        return pos;
    }

    public static BlockPos bottomOfTree(Level worldIn, BlockPos pos) {
        while (pos.m_123342_() > worldIn.m_141937_() && (worldIn.m_8055_(pos).m_204336_(BlockTags.f_13035_) || worldIn.m_8055_(pos).m_60795_() || worldIn.m_8055_(pos).m_204336_(BlockTags.f_13106_))) {
            pos = pos.m_7495_();
        }
        return pos.m_7494_();
    }

    public static boolean isNormalRotatedLog(Level level, BlockPos blockPos) {
        if (level.m_8055_(blockPos).m_60734_() instanceof RotatedPillarBlock) {
            return level.m_8055_(blockPos).m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y;
        }
        return false;
    }

    public static void searchForLogs(LevelAccessor level, BlockPos originPos, Set<BlockPos> logBlocks, Set<BlockPos> loopedLogBlocks, Set<BlockPos> leavesBlocks) {
        if (loopedLogBlocks.contains(originPos)) {
            return;
        }
        loopedLogBlocks.add(originPos);
        BlockState blockState = level.m_8055_(originPos);
        if (blockState.m_204336_(BlockTags.f_13106_)) {
            logBlocks.add(originPos);
            for (BlockPos offset : BlockPos.m_121940_((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 1, 1))) {
                BlockPos neighborPos = originPos.m_121955_((Vec3i)offset);
                TreeDetector.searchForLogs(level, neighborPos, logBlocks, loopedLogBlocks, leavesBlocks);
            }
            HashSet<BlockPos> loopedLeavesBlocks = new HashSet<BlockPos>();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = originPos.m_121955_(direction.m_122436_());
                TreeDetector.searchForLeaves(level, neighborPos, 1, leavesBlocks, loopedLeavesBlocks);
            }
        }
    }

    private static void searchForLeaves(LevelAccessor level, BlockPos originPos, int distance, Set<BlockPos> leavesBlocks, Set<BlockPos> loopedLeavesBlocks) {
        BlockState blockState = level.m_8055_(originPos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61414_) && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61414_) != distance || distance >= 7 || loopedLeavesBlocks.contains(originPos)) {
            return;
        }
        loopedLeavesBlocks.add(originPos);
        if (TreeDetector.checkLeaves(blockState)) {
            leavesBlocks.add(originPos);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = originPos.m_121955_(direction.m_122436_());
                if (distance >= 14) continue;
                TreeDetector.searchForLeaves(level, neighborPos, distance + 1, leavesBlocks, loopedLeavesBlocks);
            }
        }
    }

    private static boolean checkLeaves(BlockState blockState) {
        if (blockState.m_204336_(BlockTags.f_13072_)) {
            return true;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61447_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue()) {
            return false;
        }
        return blockState.m_204336_(BlockTags.f_13035_);
    }
}

