/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.RegistryObject;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.TDEMobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobSpawnData;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.world.TDEBiomeModifiers;

public class BiomeModifierMobSpawn
implements BiomeModifier {
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase.equals((Object)BiomeModifier.Phase.ADD)) {
            for (RegistryObject entry : TDEEntities.ENTITIES.getEntries()) {
                int maxGroupSize;
                int minGroupSize;
                MobSpawnData spawnData;
                MobProperties properties = TDEMobProperties.getResource(entry.getId());
                if (properties == null || (spawnData = properties.getMobSpawn()) == null || !spawnData.hasBiome(biome)) continue;
                EntityType entityType = (EntityType)entry.get();
                NumberProperty spawnCount = spawnData.getSpawnCount();
                if (spawnCount instanceof NumberProperty.Ranged) {
                    NumberProperty.Ranged ranged = (NumberProperty.Ranged)spawnCount;
                    minGroupSize = (int)ranged.getMinValue();
                    maxGroupSize = (int)ranged.getMaxValue();
                } else {
                    minGroupSize = spawnCount.getInt();
                    maxGroupSize = spawnCount.getInt();
                }
                this.addMobSpawn(builder, entityType.m_20674_(), entityType, spawnData.getSpawnWeight().getInt(), minGroupSize, maxGroupSize);
            }
        }
    }

    public void addMobSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, MobCategory category, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        builder.getMobSpawnSettings().m_48376_(category, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)TDEBiomeModifiers.MOB_SPAWN_CODEC.get();
    }
}

