/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.advancements.critereon.UsingItemTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import ru.xishnikus.thedawnera.common.advancement.CriteriaTriggerEatMelon;
import ru.xishnikus.thedawnera.common.advancement.CriteriaTriggerJoinGame;
import ru.xishnikus.thedawnera.common.advancement.CriteriaTriggerMeetMob;
import ru.xishnikus.thedawnera.common.advancement.CriteriaTriggerNameMob;
import ru.xishnikus.thedawnera.common.advancement.TDEAdvancements;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.block.eggs.TDEBlockEgg;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDETags;

public class TDEAdvancementProvider
extends ForgeAdvancementProvider {
    public TDEAdvancementProvider(boolean run, DataGenerator dataGenerator, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(dataGenerator.getPackOutput(), registries, existingFileHelper, List.of((regs, writer, fileHelper) -> {
            Advancement root = TDEAdvancementProvider.createRoot(writer, existingFileHelper, TDEAdvancements.THE_DAWN_ERA, "join_game", (CriterionTriggerInstance)CriteriaTriggerJoinGame.instance(), true, true, false);
            Advancement miscRoot = TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, root, TDEAdvancements.LIVING_FOSSIL, "meet_living_fossil", (CriterionTriggerInstance)CriteriaTriggerMeetMob.instance(TDETags.Entities.LIVING_FOSSIL), FrameType.TASK, true, true, false, 20);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, miscRoot, TDEAdvancements.WHY_YOU_CALL_ME_THIS_WAY, "name_mob", (CriterionTriggerInstance)CriteriaTriggerNameMob.instance(TDEEntities.DEINONYCHUS, List.of("Die-non-ih-kuss", "\u0414\u0430\u043d\u0443\u043d\u0430\u0445")), FrameType.TASK, Items.f_42656_, true, true, false, 10);
            Advancement meetDodo = TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, miscRoot, TDEAdvancements.NAIVETY_ITSELF, "meet_dodo", (CriterionTriggerInstance)CriteriaTriggerMeetMob.instance(TDEEntities.DODO), FrameType.TASK, true, true, false, 10);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, meetDodo, TDEAdvancements.THE_LAST_MELON, "eat_melon", (CriterionTriggerInstance)CriteriaTriggerEatMelon.instance(), FrameType.TASK, Blocks.f_50186_.m_5456_(), true, true, false, 10);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, miscRoot, TDEAdvancements.LIFE_FINDS_A_WAY, "get_a_dino_egg", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(TDETags.Items.PREHISTORIC_EGG).m_45077_()}), FrameType.GOAL, ((TDEBlockEgg)((Object)((Object)TDEBlocks.TRICERATOPS_EGG.get()))).m_5456_(), true, true, false, 20);
            Advancement rexRoot = TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, root, TDEAdvancements.LONG_LIVE_THE_KING, "meet_trex", (CriterionTriggerInstance)CriteriaTriggerMeetMob.instance(TDEEntities.TYRANNOSAURUS), FrameType.TASK, true, true, false, 50);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, rexRoot, TDEAdvancements.NO_KING_RULES_FOREVER, "kill_trex", (CriterionTriggerInstance)TDEAdvancementProvider.killedEntity(TDEEntities.TYRANNOSAURUS), FrameType.CHALLENGE, true, true, false, 100);
            Advancement spyGlassRoot = TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, root, TDEAdvancements.RUSSIAN_BIRDWATCHING, "spyglass_at_psittacosaurus", (CriterionTriggerInstance)TDEAdvancementProvider.lookAtThroughItem((EntityType)TDEEntities.PSITTACOSAURUS.get(), Items.f_151059_), FrameType.TASK, Items.f_151059_, true, true, false, 30);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, spyGlassRoot, TDEAdvancements.DONT_MOVE, "spyglass_at_trex", (CriterionTriggerInstance)TDEAdvancementProvider.lookAtThroughItem((EntityType)TDEEntities.TYRANNOSAURUS.get(), Items.f_151059_), FrameType.TASK, Items.f_151059_, true, true, false, 50);
            TDEAdvancementProvider.createAdvancement(writer, existingFileHelper, root, TDEAdvancements.PSITACO_BELL, "craft_psittaco", (CriterionTriggerInstance)TDEAdvancementProvider.craftItem(new ResourceLocation("dawnera:psittaco")), FrameType.TASK, (Item)TDEItems.PSITTACO.get(), true, true, false, 30);
        }));
        dataGenerator.addProvider(run, (DataProvider)this);
    }

    private static Advancement createAdvancement(Consumer<Advancement> writer, ExistingFileHelper fileHelper, Advancement parent, ResourceLocation advancementId, String criterionName, CriterionTriggerInstance criterion, FrameType frameType, boolean showToast, boolean announceInChat, boolean hidden, int experience) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        if (parent != null) {
            builder.m_138398_(parent);
        }
        return builder.m_138386_(criterionName, criterion).m_138354_(AdvancementRewards.Builder.m_10005_((int)experience)).m_138362_(ItemStack.f_41583_, (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".title")), (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".description")), null, frameType, showToast, announceInChat, hidden).save(writer, advancementId, fileHelper);
    }

    private static Advancement createAdvancement(Consumer<Advancement> writer, ExistingFileHelper fileHelper, Advancement parent, ResourceLocation advancementId, String criterionName, CriterionTriggerInstance criterion, FrameType frameType, Item item, boolean showToast, boolean announceInChat, boolean hidden, int experience) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        if (parent != null) {
            builder.m_138398_(parent);
        }
        return builder.m_138386_(criterionName, criterion).m_138354_(AdvancementRewards.Builder.m_10005_((int)experience)).m_138371_((ItemLike)item, (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".title")), (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".description")), null, frameType, showToast, announceInChat, hidden).save(writer, advancementId, fileHelper);
    }

    private static Advancement createRoot(Consumer<Advancement> writer, ExistingFileHelper fileHelper, ResourceLocation advancementId, String criterionName, CriterionTriggerInstance criterion, boolean showToast, boolean announceInChat, boolean hidden) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        return builder.m_138386_(criterionName, criterion).m_138362_(ItemStack.f_41583_, (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".title")), (Component)Component.m_237115_((String)("advancements.dawnera." + advancementId.m_135815_() + ".description")), new ResourceLocation("dawnera", "textures/gui/advancements/backgrounds/mud_paw.png"), FrameType.TASK, showToast, announceInChat, hidden).save(writer, advancementId, fileHelper);
    }

    private static <T extends Entity> KilledTrigger.TriggerInstance killedEntity(Supplier<EntityType<T>> entityType) {
        return KilledTrigger.TriggerInstance.m_152108_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(entityType.get()).m_36662_());
    }

    private static RecipeCraftedTrigger.TriggerInstance craftItem(ResourceLocation resourceLocation) {
        return RecipeCraftedTrigger.TriggerInstance.m_280097_((ResourceLocation)resourceLocation);
    }

    private static UsingItemTrigger.TriggerInstance lookAtThroughItem(EntityType<?> p_249703_, Item p_250746_) {
        return UsingItemTrigger.TriggerInstance.m_163883_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)PlayerPredicate.Builder.m_156767_().m_156771_(EntityPredicate.Builder.m_36633_().m_36636_(p_249703_).m_36662_()).m_62313_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_250746_}));
    }
}

