/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.block.eggs.TDEBlockEgg;

public class TDEBlockStateProvider
extends BlockStateProvider {
    public TDEBlockStateProvider(boolean run, DataGenerator dataGenerator, ExistingFileHelper exFileHelper) {
        super(dataGenerator.getPackOutput(), "dawnera", exFileHelper);
        dataGenerator.addProvider(run, (DataProvider)this);
    }

    protected void registerStatesAndModels() {
        this.randomPlacedBlock((Supplier<Block>)TDEBlocks.WORM_DIRT);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.DEINONYCHUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.DIMORPHODON_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.DODO_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.DUNKLEOSTEUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.TYRANNOSAURUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.TRICERATOPS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.STRUTHIOMIMUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.PSITTACOSAURUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.CERATOSAURUS_EGG);
        this.dinoEgg((Supplier<TDEBlockEgg>)TDEBlocks.DIABLOCERATOPS_EGG);
    }

    public void randomPlacedBlock(Supplier<Block> blockSupplier) {
        Block block = blockSupplier.get();
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        ModelFile.UncheckedModelFile modelFile = new ModelFile.UncheckedModelFile(new ResourceLocation("dawnera", "block/" + this.name(block)));
        builder.addModels(builder.partialState(), new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)modelFile).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(90).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(180).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(270).buildLast()});
    }

    public void dinoEgg(Supplier<TDEBlockEgg> blockSupplier) {
        TDEBlockEgg block = blockSupplier.get();
        String eggName = this.name((Block)block);
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (int eggCount = 1; eggCount <= block.getMaxEggs(); ++eggCount) {
            for (int hatchLevel = 0; hatchLevel <= block.getMaxHatchLevel(); ++hatchLevel) {
                VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
                partialBlockstate = partialBlockstate.with((Property)block.getPropertyHatchStage(), (Comparable)Integer.valueOf(hatchLevel));
                if (block.getMaxEggs() > 1) {
                    partialBlockstate = partialBlockstate.with((Property)block.getPropertyEggCount(), (Comparable)Integer.valueOf(eggCount));
                }
                ModelFile.UncheckedModelFile modelFile = new ModelFile.UncheckedModelFile(new ResourceLocation("dawnera", "block/" + eggName + "/" + eggName + "_stage_" + hatchLevel + "_eggs_" + eggCount));
                builder.addModels(partialBlockstate, new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)modelFile).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(90).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(180).buildLast(), ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(270).buildLast()});
            }
        }
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }
}

