/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.item.TDEItems;

public class TDEItemModelProvider
extends ItemModelProvider {
    public TDEItemModelProvider(boolean run, DataGenerator dataGenerator, ExistingFileHelper exFileHelper) {
        super(dataGenerator.getPackOutput(), "dawnera", exFileHelper);
        dataGenerator.addProvider(run, (DataProvider)this);
    }

    protected void registerModels() {
        this.registerBlocks();
        this.registerFoods();
        this.registerSpawnEggs();
        this.registerMisc();
    }

    private void registerMisc() {
        this.generated(new ResourceLocation("dawnera", "struthiomimus_feather"));
        this.generated(new ResourceLocation("dawnera", "dodo_feather"));
        this.generated((Supplier<? extends ItemLike>)TDEItems.TRICERATOPS_HORN);
        this.generated((Supplier<? extends ItemLike>)TDEItems.INSPECTING_SPYGLASS);
        this.generated((Supplier<? extends ItemLike>)TDEItems.DIPLORANG);
        this.generated((Supplier<? extends ItemLike>)TDEItems.DIPLOCAULUS_BUCKET);
        this.generated((Supplier<? extends ItemLike>)TDEItems.CERATOSAURUS_ARMOR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.CERATOSAURUS_SADDLE);
        this.generated((Supplier<? extends ItemLike>)TDEItems.DIABLOCERATOPS_ARMOR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.DIABLOCERATOPS_SADDLE);
        this.generated((Supplier<? extends ItemLike>)TDEItems.TRICERATOPS_ARMOR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.TRICERATOPS_SADDLE);
        this.generated((Supplier<? extends ItemLike>)TDEItems.TYRANNOSAURUS_ARMOR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.TYRANNOSAURUS_SADDLE);
    }

    private void registerBlocks() {
        this.block((Supplier<? extends Block>)TDEBlocks.WORM_DIRT);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.CERATOSAURUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DEINONYCHUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DODO_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DIMORPHODON_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DIABLOCERATOPS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.TRICERATOPS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.TYRANNOSAURUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.PSITTACOSAURUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.STRUTHIOMIMUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DUNKLEOSTEUS_EGG);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.ALLIGATOR_GAR_ROE);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.DIPLOCAULUS_ROE);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.SABERTOOTH_SALMON_ROE);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.STURGEON_ROE);
        this.generated((Supplier<? extends ItemLike>)TDEBlocks.SEAGRASS_EGGS);
    }

    private void registerFoods() {
        this.generated((Supplier<? extends ItemLike>)TDEItems.CAVIAR_SANDWICH);
        this.generated((Supplier<? extends ItemLike>)TDEItems.PSITTACO);
        this.generated((Supplier<? extends ItemLike>)TDEItems.WORM);
        this.generated((Supplier<? extends ItemLike>)TDEItems.BOWL_OF_CAVIAR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_ROE);
        this.generated((Supplier<? extends ItemLike>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_SOUP);
        this.generated((Supplier<? extends ItemLike>)TDEItems.PSITTACOSAURUS_MEAT);
        this.generated((Supplier<? extends ItemLike>)TDEItems.STRUTHIOMIMUS_MEAT);
        this.generated((Supplier<? extends ItemLike>)TDEItems.RAW_COELACANTH);
        this.generated((Supplier<? extends ItemLike>)TDEItems.RAW_ALLIGATOR_GAR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.RAW_SABERTOOTH_SALMON);
        this.generated((Supplier<? extends ItemLike>)TDEItems.RAW_STURGEON);
        this.generated((Supplier<? extends ItemLike>)TDEItems.RAW_DODO);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_PSITTACOSAURUS_MEAT);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_STRUTHIOMIMUS_MEAT);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_COELACANTH);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_ALLIGATOR_GAR);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_SABERTOOTH_SALMON);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_STURGEON);
        this.generated((Supplier<? extends ItemLike>)TDEItems.COOKED_DODO);
    }

    private void registerSpawnEggs() {
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.ALLIGATOR_GAR_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.CERATOSAURUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.STRUTHIOMIMUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.COELACANTH_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.STURGEON_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.WORM_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.TYRANNOSAURUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.TRICERATOPS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.SABERTOOTH_SALMON_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DEINONYCHUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DIPLOCAULUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DIABLOCERATOPS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DIMORPHODON_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DODO_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.DUNKLEOSTEUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.MIXOSAURUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.POND_SNAIL_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.PSITTACOSAURUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.SACHICASAURUS_SPAWN_EGG);
        this.spawnEgg((Supplier<? extends ItemLike>)TDEItems.AEGIROCASSIS_SPAWN_EGG);
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        ResourceLocation loc = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get()));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(loc.m_135827_() + ":block/" + loc.m_135815_()));
    }

    public ItemModelBuilder spawnEgg(Supplier<? extends ItemLike> item) {
        ResourceLocation loc = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get().m_5456_()));
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }

    public ItemModelBuilder generated(Supplier<? extends ItemLike> item) {
        ResourceLocation loc = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.get().m_5456_()));
        return this.generated(loc);
    }

    public ItemModelBuilder generated(ResourceLocation loc) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(loc.m_135827_(), "item/" + loc.m_135815_()));
    }
}

