/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import ru.xishnikus.thedawnera.common.advancement.TDEAdvancements;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.enchantment.TDEEnchantments;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDECreativeTabs;
import ru.xishnikus.thedawnera.datagen.misc.DataProviderMultiLanguage;

public class TDELangProvider
extends DataProviderMultiLanguage {
    public TDELangProvider(boolean run, DataGenerator dataGenerator) {
        super(dataGenerator.getPackOutput(), "dawnera");
        dataGenerator.addProvider(run, (DataProvider)this);
    }

    @Override
    protected void addTranslations() {
        this.registerItems();
        this.registerBlocks();
        this.registerEntities();
        this.registerSubtitles();
        this.registerAdvancements();
        this.registerEnchantments();
        this.registerMisc();
    }

    private void registerEnchantments() {
        this.addEnchantment(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Enchantment>)TDEEnchantments.AIR_CUTTER, "Air Cutter");
        this.addEnchantment(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Enchantment>)TDEEnchantments.AIR_CUTTER, "\u0412\u043e\u0437\u0434\u0443\u0445\u043e\u0440\u0435\u0437");
        this.addEnchantment(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Enchantment>)TDEEnchantments.PENETRATION, "Penetration");
        this.addEnchantment(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Enchantment>)TDEEnchantments.PENETRATION, "\u041f\u0440\u043e\u043d\u0438\u043a\u043d\u043e\u0432\u0435\u043d\u0438\u0435");
        this.addEnchantment(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Enchantment>)TDEEnchantments.DEVOTED, "Devotion");
        this.addEnchantment(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Enchantment>)TDEEnchantments.DEVOTED, "\u041f\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0441\u0442\u044c");
    }

    private void registerItems() {
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DUNKLEOSTEUS_SPAWN_EGG, "Dunkleosteus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DUNKLEOSTEUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u044f");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.STRUTHIOMIMUS_SPAWN_EGG, "Struthiomimus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.STRUTHIOMIMUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0441\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_SPAWN_EGG, "Ceratosaurus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0446\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.SACHICASAURUS_SPAWN_EGG, "Sachicasaurus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.SACHICASAURUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0441\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.AEGIROCASSIS_SPAWN_EGG, "Aegirocassis Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.AEGIROCASSIS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u044d\u0433\u0438\u0440\u043e\u043a\u0430\u0441\u0441\u0438\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.STURGEON_SPAWN_EGG, "Sturgeon Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.STURGEON_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u043e\u0441\u0435\u0442\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.POND_SNAIL_SPAWN_EGG, "Pond Snail Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.POND_SNAIL_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u043f\u0440\u0443\u0434\u043e\u0432\u0438\u043a\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.WORM_SPAWN_EGG, "Worm Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.WORM_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0447\u0435\u0440\u0432\u044f");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIMORPHODON_SPAWN_EGG, "Dimorphodon Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIMORPHODON_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_SPAWN_EGG, "Diabloceratops Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_SPAWN_EGG, "Tyrannosaurus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.PSITTACOSAURUS_SPAWN_EGG, "Psittacosaurus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.PSITTACOSAURUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u043f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COELACANTH_SPAWN_EGG, "Coelacanth Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COELACANTH_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0446\u0435\u043b\u0430\u043a\u0430\u043d\u0442\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.SABERTOOTH_SALMON_SPAWN_EGG, "Sabertooth Salmon Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.SABERTOOTH_SALMON_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u043e\u0433\u043e \u043b\u043e\u0441\u043e\u0441\u044f");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.ALLIGATOR_GAR_SPAWN_EGG, "Alligator Gar Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.ALLIGATOR_GAR_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u043f\u0430\u043d\u0446\u0438\u0440\u043d\u043e\u0439 \u0449\u0443\u043a\u0438");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TRICERATOPS_SPAWN_EGG, "Triceratops Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TRICERATOPS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0442\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.MIXOSAURUS_SPAWN_EGG, "Mixosaurus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.MIXOSAURUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u043c\u0438\u043a\u0441\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DODO_SPAWN_EGG, "Dodo Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DODO_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0440\u043e\u043d\u0442\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DEINONYCHUS_SPAWN_EGG, "Deinonychus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DEINONYCHUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0435\u0439\u043d\u043e\u043d\u0438\u0445\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIPLOCAULUS_SPAWN_EGG, "Diplocaulus Spawn Egg");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIPLOCAULUS_SPAWN_EGG, "\u042f\u0439\u0446\u043e \u043f\u0440\u0438\u0437\u044b\u0432\u0430 \u0434\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.INSPECTING_SPYGLASS, "Inspecting Spyglass");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.INSPECTING_SPYGLASS, "\u041e\u0431\u0437\u043e\u0440\u043d\u0430\u044f \u0442\u0440\u0443\u0431\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.RAW_STURGEON, "Raw Sturgeon");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.RAW_STURGEON, "\u0421\u044b\u0440\u0430\u044f \u043e\u0441\u0435\u0442\u0440\u0438\u043d\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_STURGEON, "Cooked Sturgeon");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_STURGEON, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f \u043e\u0441\u0435\u0442\u0440\u0438\u043d\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.PSITTACOSAURUS_MEAT, "Psittacosaurus Meat");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.PSITTACOSAURUS_MEAT, "\u041c\u044f\u0441\u043e \u043f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_PSITTACOSAURUS_MEAT, "Cooked Psittacosaurus Meat");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_PSITTACOSAURUS_MEAT, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u043c\u044f\u0441\u043e \u043f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.PSITTACO, "Psittaco");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.PSITTACO, "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.STRUTHIOMIMUS_MEAT, "Struthiomimus Meat");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.STRUTHIOMIMUS_MEAT, "\u041c\u044f\u0441\u043e \u0441\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_STRUTHIOMIMUS_MEAT, "Cooked Struthiomimus Meat");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_STRUTHIOMIMUS_MEAT, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u043c\u044f\u0441\u043e \u0441\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.WORM, "Worm");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.WORM, "\u0427\u0435\u0440\u0432\u044c");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.BOWL_OF_CAVIAR, "Bowl of Caviar");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.BOWL_OF_CAVIAR, "\u041c\u0438\u0441\u043a\u0430 \u0441 \u0447\u0451\u0440\u043d\u043e\u0439 \u0438\u043a\u0440\u043e\u0439");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_ROE, "Bowl of Sabertooth Salmon Roe");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_ROE, "\u041c\u0438\u0441\u043a\u0430 \u0441 \u0438\u043a\u0440\u043e\u0439 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u043e\u0433\u043e \u043b\u043e\u0441\u043e\u0441\u044f");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_SOUP, "Bowl of Sabertooth Salmon Soup");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.BOWL_OF_SABERTOOTH_SALMON_SOUP, "\u041c\u0438\u0441\u043a\u0430 \u0441 \u0441\u0443\u043f\u043e\u043c \u0438\u0437 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u043e\u0433\u043e \u043b\u043e\u0441\u043e\u0441\u044f");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.CAVIAR_SANDWICH, "Caviar Sandwich");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.CAVIAR_SANDWICH, "\u0411\u0443\u0442\u0435\u0440\u0431\u0440\u043e\u0434 \u0441 \u0447\u0451\u0440\u043d\u043e\u0439 \u0438\u043a\u0440\u043e\u0439");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.RAW_COELACANTH, "Raw Coelacanth");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.RAW_COELACANTH, "\u0421\u044b\u0440\u043e\u0439 \u0446\u0435\u043b\u0430\u043a\u0430\u043d\u0442");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_COELACANTH, "Cooked Coelacanth");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_COELACANTH, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0446\u0435\u043b\u0430\u043a\u0430\u043d\u0442");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.RAW_SABERTOOTH_SALMON, "Raw Sabertooth Salmon");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.RAW_SABERTOOTH_SALMON, "\u0421\u044b\u0440\u043e\u0439 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u044b\u0439 \u043b\u043e\u0441\u043e\u0441\u044c");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_SABERTOOTH_SALMON, "Cooked Sabertooth Salmon");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_SABERTOOTH_SALMON, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u044b\u0439 \u043b\u043e\u0441\u043e\u0441\u044c");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.RAW_ALLIGATOR_GAR, "Raw Alligator Gar");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.RAW_ALLIGATOR_GAR, "\u0421\u044b\u0440\u0430\u044f \u043f\u0430\u043d\u0446\u0438\u0440\u043d\u0430\u044f \u0449\u0443\u043a\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_ALLIGATOR_GAR, "Cooked Alligator Gar");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_ALLIGATOR_GAR, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f \u043f\u0430\u043d\u0446\u0438\u0440\u043d\u0430\u044f \u0449\u0443\u043a\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.RAW_DODO, "Raw Dodo");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.RAW_DODO, "\u0421\u044b\u0440\u043e\u0439 \u0434\u0440\u043e\u043d\u0442");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.COOKED_DODO, "Cooked Dodo");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.COOKED_DODO, "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0434\u0440\u043e\u043d\u0442");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_SADDLE, "Diabloceratops Saddle");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_SADDLE, "\u0421\u0435\u0434\u043b\u043e \u043d\u0430 \u0434\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_ARMOR, "Diabloceratops Armor");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIABLOCERATOPS_ARMOR, "\u0411\u0440\u043e\u043d\u044f \u043d\u0430 \u0434\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_SADDLE, "Ceratosaurus Saddle");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_SADDLE, "\u0421\u0435\u0434\u043b\u043e \u043d\u0430 \u0446\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_ARMOR, "Ceratosaurus Armor");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.CERATOSAURUS_ARMOR, "\u0411\u0440\u043e\u043d\u044f \u043d\u0430 \u0446\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_SADDLE, "Tyrannosaurus Saddle");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_SADDLE, "\u0421\u0435\u0434\u043b\u043e \u043d\u0430 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_ARMOR, "Tyrannosaurus Armor");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TYRANNOSAURUS_ARMOR, "\u0411\u0440\u043e\u043d\u044f \u043d\u0430 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TRICERATOPS_SADDLE, "Triceratops Saddle");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TRICERATOPS_SADDLE, "\u0421\u0435\u0434\u043b\u043e \u043d\u0430 \u0442\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TRICERATOPS_ARMOR, "Triceratops Armor");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TRICERATOPS_ARMOR, "\u0411\u0440\u043e\u043d\u044f \u043d\u0430 \u0442\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.TRICERATOPS_HORN, "Triceratops Horn");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.TRICERATOPS_HORN, "\u0420\u043e\u0433 \u0442\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIPLORANG, "Diplorang");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIPLORANG, "\u0414\u0438\u043f\u043b\u043e\u0440\u0430\u043d\u0433");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.DIPLOCAULUS_BUCKET, "Bucket Of Diplocaulus");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.DIPLOCAULUS_BUCKET, "\u0412\u0435\u0434\u0440\u043e \u0441 \u0434\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441\u043e\u043c");
        this.addItem(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Item>)TDEItems.BONE_WHISTLE, "Bone Whistle");
        this.addItem(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Item>)TDEItems.BONE_WHISTLE, "\u041a\u043e\u0441\u0442\u044f\u043d\u043e\u0439 \u0441\u0432\u0438\u0441\u0442\u043e\u043a");
    }

    private void registerBlocks() {
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DUNKLEOSTEUS_EGG, "Dunkleosteus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DUNKLEOSTEUS_EGG, "\u042f\u0439\u0446\u043e \u0434\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u044f");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.STURGEON_ROE, "Sturgeon Caviar");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.STURGEON_ROE, "\u0418\u043a\u0440\u0430 \u043e\u0441\u0435\u0442\u0440\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.SABERTOOTH_SALMON_ROE, "Sabertooth Salmon Roe");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.SABERTOOTH_SALMON_ROE, "\u0418\u043a\u0440\u0430 \u0441\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u043e\u0433\u043e \u043b\u043e\u0441\u043e\u0441\u044f");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.ALLIGATOR_GAR_ROE, "Alligator Gar Roe");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.ALLIGATOR_GAR_ROE, "\u0418\u043a\u0440\u0430 \u043f\u0430\u043d\u0446\u0438\u0440\u043d\u043e\u0439 \u0449\u0443\u043a\u0438");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DIPLOCAULUS_ROE, "Diplocaulus Roe");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DIPLOCAULUS_ROE, "\u0418\u043a\u0440\u0430 \u0434\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.CERATOSAURUS_EGG, "Ceratosaurus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.CERATOSAURUS_EGG, "\u042f\u0439\u0446\u043e \u0446\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DIMORPHODON_EGG, "Dimorphodon Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DIMORPHODON_EGG, "\u042f\u0439\u0446\u043e \u0434\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.STRUTHIOMIMUS_EGG, "Struthiomimus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.STRUTHIOMIMUS_EGG, "\u042f\u0439\u0446\u043e \u0441\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DIABLOCERATOPS_EGG, "Diabloceratops Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DIABLOCERATOPS_EGG, "\u042f\u0439\u0446\u043e \u0434\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.PSITTACOSAURUS_EGG, "Psittacosaurus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.PSITTACOSAURUS_EGG, "\u042f\u0439\u0446\u043e \u043f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DEINONYCHUS_EGG, "Deinonychus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DEINONYCHUS_EGG, "\u042f\u0439\u0446\u043e \u0434\u0435\u0439\u043d\u043e\u043d\u0438\u0445\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.DODO_EGG, "Dodo Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.DODO_EGG, "\u042f\u0439\u0446\u043e \u0434\u043e\u0434\u043e");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.TRICERATOPS_EGG, "Triceratops Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.TRICERATOPS_EGG, "\u042f\u0439\u0446\u043e \u0442\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.TYRANNOSAURUS_EGG, "Tyrannosaurus Egg");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.TYRANNOSAURUS_EGG, "\u042f\u0439\u0446\u043e \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.SEAGRASS_EGGS, "Fertilized Sea Grass");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.SEAGRASS_EGGS, "\u041e\u043f\u043b\u043e\u0434\u043e\u0442\u0432\u043e\u0440\u0451\u043d\u043d\u0430\u044f \u043c\u043e\u0440\u0441\u043a\u0430\u044f \u0442\u0440\u0430\u0432\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.TALL_SEAGRASS_EGGS, "Fertilized Tall Sea Grass");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.TALL_SEAGRASS_EGGS, "\u0412\u044b\u0441\u043e\u043a\u0430\u044f \u043e\u043f\u043b\u043e\u0434\u043e\u0442\u0432\u043e\u0440\u0451\u043d\u043d\u0430\u044f \u043c\u043e\u0440\u0441\u043a\u0430\u044f \u0442\u0440\u0430\u0432\u0430");
        this.addBlock(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends Block>)TDEBlocks.WORM_DIRT, "Wormy Dirt");
        this.addBlock(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends Block>)TDEBlocks.WORM_DIRT, "\u0427\u0435\u0440\u0432\u0438\u0432\u0430\u044f \u0437\u0435\u043c\u043b\u044f");
    }

    private void registerEntities() {
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.TYRANNOSAURUS, "Tyrannosaurus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.TYRANNOSAURUS, "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.TRICERATOPS, "Triceratops");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.TRICERATOPS, "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.PSITTACOSAURUS, "Psittacosaurus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.PSITTACOSAURUS, "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DUNKLEOSTEUS, "Dunkleosteus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DUNKLEOSTEUS, "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DIABLOCERATOPS, "Diabloceratops");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DIABLOCERATOPS, "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.STRUTHIOMIMUS, "Struthiomimus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.STRUTHIOMIMUS, "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.CERATOSAURUS, "Ceratosaurus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.CERATOSAURUS, "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DIMORPHODON, "Dimorphodon");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DIMORPHODON, "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.STURGEON, "Sturgeon");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.STURGEON, "\u041e\u0441\u0451\u0442\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.MIXOSAURUS, "Mixosaurus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.MIXOSAURUS, "\u041c\u0438\u043a\u0441\u043e\u0437\u0430\u0432\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.ALLIGATOR_GAR, "Alligator Gar");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.ALLIGATOR_GAR, "\u041f\u0430\u043d\u0446\u0438\u0440\u043d\u0430\u044f \u0449\u0443\u043a\u0430");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.COELACANTH, "Coelacanth");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.COELACANTH, "\u0426\u0435\u043b\u0430\u043a\u0430\u043d\u0442");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.SACHICASAURUS, "Sachicasaurus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.SACHICASAURUS, "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.SABERTOOTH_SALMON, "Sabertooth Salmon");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.SABERTOOTH_SALMON, "\u0421\u0430\u0431\u043b\u0435\u0437\u0443\u0431\u044b\u0439 \u043b\u043e\u0441\u043e\u0441\u044c");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.POND_SNAIL, "Pond Snail");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.POND_SNAIL, "\u041f\u0440\u0443\u0434\u043e\u0432\u0438\u043a");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.WORM, "Worm");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.WORM, "\u0427\u0435\u0440\u0432\u044c");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DODO, "Dodo");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DODO, "\u0414\u0440\u043e\u043d\u0442");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.AEGIROCASSIS, "Aegirocassis");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.AEGIROCASSIS, "\u042d\u0433\u0438\u0440\u043e\u043a\u0430\u0441\u0441\u0438\u0441");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DEINONYCHUS, "Deinonychus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DEINONYCHUS, "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DIPLOCAULUS, "Diplocaulus");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DIPLOCAULUS, "\u0414\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.FALLING_TREE, "Falling Tree");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.FALLING_TREE, "\u041f\u0430\u0434\u0430\u044e\u0449\u0435\u0435 \u0434\u0435\u0440\u0435\u0432\u043e");
        this.addEntityType(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends EntityType<?>>)TDEEntities.DIPLORANG, "Diplorang");
        this.addEntityType(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends EntityType<?>>)TDEEntities.DIPLORANG, "\u0414\u0438\u043f\u043b\u043e\u0440\u0430\u043d\u0433");
    }

    private void registerMisc() {
        this.addEffect(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends MobEffect>)TDEMobEffects.FRACTURE, "Fracture");
        this.addEffect(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends MobEffect>)TDEMobEffects.FRACTURE, "\u041f\u0435\u0440\u0435\u043b\u043e\u043c");
        this.addEffect(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends MobEffect>)TDEMobEffects.BLEEDING, "Bleeding");
        this.addEffect(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends MobEffect>)TDEMobEffects.BLEEDING, "\u041a\u0440\u043e\u0432\u043e\u0442\u0435\u0447\u0435\u043d\u0438\u0435");
        this.addEffect(DataProviderMultiLanguage.Language.ENGLISH, (Supplier<? extends MobEffect>)TDEMobEffects.AMPHIBIAN_MADNESS, "Amphibian Madness");
        this.addEffect(DataProviderMultiLanguage.Language.RUSSIAN, (Supplier<? extends MobEffect>)TDEMobEffects.AMPHIBIAN_MADNESS, "\u0411\u0435\u0448\u0435\u043d\u0441\u0442\u0432\u043e \u0430\u043c\u0444\u0438\u0431\u0438\u0438");
        this.addCreativeTab(DataProviderMultiLanguage.Language.ENGLISH, TDECreativeTabs.THE_DAWN_ERA, "The Dawn Era");
        this.addCreativeTab(DataProviderMultiLanguage.Language.RUSSIAN, TDECreativeTabs.THE_DAWN_ERA, "\u042d\u043f\u043e\u0445\u0430 \u0440\u0430\u0441\u0441\u0432\u0435\u0442\u0430");
        this.addGender(DataProviderMultiLanguage.Language.ENGLISH, GenderType.FEMALE, "Female");
        this.addGender(DataProviderMultiLanguage.Language.RUSSIAN, GenderType.FEMALE, "\u0416\u0435\u043d\u0441\u043a\u0438\u0439");
        this.addGender(DataProviderMultiLanguage.Language.ENGLISH, GenderType.MALE, "Male");
        this.addGender(DataProviderMultiLanguage.Language.RUSSIAN, GenderType.MALE, "\u041c\u0443\u0436\u0441\u043a\u043e\u0439");
        this.addGender(DataProviderMultiLanguage.Language.ENGLISH, GenderType.HERMAPHRODITE, "Hermaphrodite");
        this.addGender(DataProviderMultiLanguage.Language.RUSSIAN, GenderType.HERMAPHRODITE, "\u0413\u0435\u0440\u043c\u0430\u0444\u0440\u043e\u0434\u0438\u0442");
        this.addGender(DataProviderMultiLanguage.Language.ENGLISH, GenderType.UNKNOWN, "Unknown");
        this.addGender(DataProviderMultiLanguage.Language.RUSSIAN, GenderType.UNKNOWN, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "inspecting.dawnera.name", "Name");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "inspecting.dawnera.name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "inspecting.dawnera.gender", "Sex");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "inspecting.dawnera.gender", "\u041f\u043e\u043b");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "inspecting.dawnera.health", "Health");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "inspecting.dawnera.health", "\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "inspecting.dawnera.hunger", "Hunger");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "inspecting.dawnera.hunger", "\u0413\u043e\u043b\u043e\u0434");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "inspecting.dawnera.stamina", "Stamina");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "inspecting.dawnera.stamina", "\u0412\u044b\u043d\u043e\u0441\u043b\u0438\u0432\u043e\u0441\u0442\u044c");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "order.dawnera.behaviour", "Behaviour");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "order.dawnera.behaviour", "\u041f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "order.dawnera.eating", "Eating");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "order.dawnera.eating", "\u041f\u0438\u0442\u0430\u043d\u0438\u0435");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "order.dawnera.accessibility", "Access");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "order.dawnera.accessibility", "\u0414\u043e\u0441\u0442\u0443\u043f");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "order.dawnera.movement", "Movement");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "order.dawnera.movement", "\u041f\u0435\u0440\u0435\u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0435");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "order.dawnera.specific", "Action");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "order.dawnera.specific", "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Movement.FOLLOW, "Follow", "%1$s is now following you.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Movement.FOLLOW, "\u0421\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430 \u0432\u0430\u043c\u0438.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Movement.WANDER, "Wander", "%1$s is now wandering.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Movement.WANDER, "\u0411\u043b\u0443\u0436\u0434\u0430\u0442\u044c", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0431\u043b\u0443\u0436\u0434\u0430\u0435\u0442.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Movement.WAIT, "Wait", "%1$s is now waiting.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Movement.WAIT, "\u0416\u0434\u0430\u0442\u044c", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0436\u0434\u0451\u0442 \u0432\u0430\u0441.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Eating.ALLOW_EAT, "Allow", "%1$s is now allowed to eat.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Eating.ALLOW_EAT, "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0435\u0441\u0442\u044c.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Eating.DENY_EAT, "Deny", "%1$s is now forbidden to eat.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Eating.DENY_EAT, "\u0417\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0435\u0441\u0442\u044c.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Accessibility.PUBLIC, "Public", "%1$s is now mountable for anyone.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Accessibility.PUBLIC, "\u041e\u0431\u0449\u0438\u0439", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u043c\u043e\u0436\u0435\u0442 \u043e\u0441\u0435\u0434\u043b\u0430\u0442\u044c \u043b\u044e\u0431\u043e\u0439 \u0447\u0435\u043b\u043e\u0432\u0435\u043a.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Accessibility.PRIVATE, "Private", "%1$s is now mountable only for you.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Accessibility.PRIVATE, "\u041f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0441\u0435\u0434\u043b\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u044b.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Specific.NO_ORDER, "None", "%1$s is now inactive.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Specific.NO_ORDER, "\u041d\u0435\u0442", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435 \u0434\u0435\u043b\u0430\u0435\u0442.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Specific.GATHERING, "Gathering", "%1$s is now gathering resources.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Specific.GATHERING, "\u0421\u0431\u043e\u0440", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0441\u043e\u0431\u0438\u0440\u0430\u0435\u0442 \u0440\u0435\u0441\u0443\u0440\u0441\u044b.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Behaviour.AGGRESSIVE, "Aggressive", "%1$s is now attacking targets.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Behaviour.AGGRESSIVE, "\u0410\u0433\u0440\u0435\u0441\u0441\u0438\u044f", "%1$s \u0442\u0435\u043f\u0435\u0440\u044c \u0430\u0442\u0430\u043a\u0443\u0435\u0442 \u0446\u0435\u043b\u0438.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Behaviour.PASSIVE, "Passive", "%1$s is now defending itself.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Behaviour.PASSIVE, "\u041f\u0430\u0441\u0441\u0438\u0432\u043d\u044b\u0439", "%1$s \u0437\u0430\u0449\u0438\u0449\u0430\u0435\u0442 \u0441\u0435\u0431\u044f.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.Behaviour.IGNORE, "Ignore", "%1$s is now ignoring targets.");
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.Behaviour.IGNORE, "\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", "%1$s \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442 \u0446\u0435\u043b\u0438.");
        this.addMobOrder(DataProviderMultiLanguage.Language.ENGLISH, MobOrder.PlayerClick.INVENTORY, "Inventory", null);
        this.addMobOrder(DataProviderMultiLanguage.Language.RUSSIAN, MobOrder.PlayerClick.INVENTORY, "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c", null);
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "gui.dawnera.back", "Back");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "gui.dawnera.back", "\u041d\u0430\u0437\u0430\u0434");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "msg.dawnera.tame", "You tamed %1$s!");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "msg.dawnera.tame", "\u0412\u044b \u043f\u0440\u0438\u0440\u0443\u0447\u0438\u043b\u0438 %1$s!");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "death.attack.fracture", "%1$s attempted to move with their broken limbs");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "death.attack.fracture", "%1$s \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u0434\u0432\u0438\u0433\u0430\u0442\u044c \u0441\u043b\u043e\u043c\u0430\u043d\u043d\u044b\u043c\u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0441\u0442\u044f\u043c\u0438");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "death.attack.bleeding", "%1$s forgot about the bleeding");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "death.attack.bleeding", "%1$s \u0437\u0430\u0431\u044b\u043b \u0447\u0442\u043e \u0438\u0441\u0442\u0435\u043a\u0430\u0435\u0442 \u043a\u0440\u043e\u0432\u044c\u044e");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "death.attack.boomerang", "%1$s was knocked by %2$s");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "death.attack.boomerang", "%1$s \u0432\u044b\u0440\u0443\u0431\u0438\u043b\u0438 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e %2$s");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "key.dawnera.attack", "Attack");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "key.dawnera.attack", "\u0410\u0442\u0430\u043a\u0430");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "key.dawnera.roar", "Roar");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "key.dawnera.roar", "\u0420\u044b\u043a");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "key.dawnera.open_menu", "Open interact menu");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "key.dawnera.open_menu", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        this.add(DataProviderMultiLanguage.Language.ENGLISH, "key.categories.dawnera", "The Dawn Era");
        this.add(DataProviderMultiLanguage.Language.RUSSIAN, "key.categories.dawnera", "\u042d\u0440\u0430 \u0440\u0430\u0441\u0441\u0432\u0435\u0442\u0430");
    }

    private void registerAdvancements() {
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.THE_DAWN_ERA, "The Dawn Era", "This era has just begun, are you prepared for it?");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.THE_DAWN_ERA, "\u042d\u0440\u0430 \u0440\u0430\u0441\u0441\u0432\u0435\u0442\u0430", "\u042d\u0442\u0430 \u044d\u0440\u0430, \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430\u0447\u0430\u043b\u0430\u0441\u044c, \u043f\u0440\u0430\u0432\u0434\u0430 \u043b\u0438 \u0432\u044b \u0433\u043e\u0442\u043e\u0432\u044b \u043a \u043d\u0435\u0439?");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.LONG_LIVE_THE_KING, "Long Live The King!", "Meet Tyrannosaurus, a terrifying lizard from the distant past");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.LONG_LIVE_THE_KING, "\u0414\u0430 \u0437\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u0440\u043e\u043b\u044c!", "\u0412\u0441\u0442\u0440\u0435\u0442\u044c\u0442\u0435 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430, \u0443\u0436\u0430\u0441\u0430\u044e\u0449\u0435\u0433\u043e \u044f\u0449\u0435\u0440\u0430 \u0438\u0437 \u0434\u0430\u043b\u0451\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0448\u043b\u043e\u0433\u043e");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.NO_KING_RULES_FOREVER, "No King Rules Forever", "Knock the Tyrannosaurus off its place in the food chain");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.NO_KING_RULES_FOREVER, "\u041a\u043e\u0440\u043e\u043b\u0438 \u043d\u0435 \u043f\u0440\u0430\u0432\u044f\u0442 \u0432\u0435\u0447\u043d\u043e", "\u0421\u043c\u0435\u0441\u0442\u0438\u0442\u0435 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430 \u0441 \u0435\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0432 \u043f\u0438\u0449\u0435\u0432\u043e\u0439 \u0446\u0435\u043f\u043e\u0447\u043a\u0435");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.DONT_MOVE, "Don't Move", "Look at a Tyrannosaurus through a Spyglass");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.DONT_MOVE, "\u041d\u0435 \u0434\u0432\u0438\u0433\u0430\u0439\u0442\u0435\u0441\u044c", "\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043d\u0430 \u0442\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0434\u0437\u043e\u0440\u043d\u0443\u044e \u0442\u0440\u0443\u0431\u0443");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.PSITACO_BELL, "PsiTaco Bell", "Craft a Psittaco");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.PSITACO_BELL, "\u0413\u0440\u0443\u0441\u0442\u043d\u043e, \u043d\u043e \u0432\u043a\u0443\u0441\u043d\u043e!", "\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u044c\u0442\u0435 \u043f\u0441\u0438\u0442\u0430\u043a\u043e");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.LIFE_FINDS_A_WAY, "Life Finds A Way", "Get a dinosaur egg");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.LIFE_FINDS_A_WAY, "\u0416\u0438\u0437\u043d\u044c \u043d\u0430\u0439\u0434\u0451\u0442 \u0434\u043e\u0440\u043e\u0433\u0443", "\u0420\u0430\u0437\u0434\u043e\u0431\u0443\u0434\u044c\u0442\u0435 \u044f\u0439\u0446\u043e \u0434\u0438\u043d\u043e\u0437\u0430\u0432\u0440\u0430");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.RUSSIAN_BIRDWATCHING, "Russian Birdwatching", "Look at a Psittacosaurus through a Spyglass");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.RUSSIAN_BIRDWATCHING, "\u0420\u0443\u0441\u0441\u043a\u0438\u0439 \u043f\u0442\u0438\u0447\u043d\u0438\u043a", "\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043d\u0430 \u043f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0434\u0437\u043e\u0440\u043d\u0443\u044e \u0442\u0440\u0443\u0431\u0443");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.LIVING_FOSSIL, "Living Fossil", "Find one of modern day, well-preserved, prehistoric fish");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.LIVING_FOSSIL, "\u0416\u0438\u0432\u043e\u0435 \u0438\u0441\u043a\u043e\u043f\u0430\u0435\u043c\u043e\u0435", "\u041e\u0442\u044b\u0449\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u0437 \u0445\u043e\u0440\u043e\u0448\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0432\u0448\u0438\u0445\u0441\u044f \u0432 \u043d\u0430\u0448\u0435 \u0432\u0440\u0435\u043c\u044f, \u0434\u043e\u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u044b\u0431");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.THE_LAST_MELON, "The Last Melon", "Eat the last piece of watermelon in front of a Dodo");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.THE_LAST_MELON, "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0430\u0440\u0431\u0443\u0437", "\u0421\u044a\u0435\u0448\u044c\u0442\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043a\u0443\u0441\u043e\u0447\u0435\u043a \u0430\u0440\u0431\u0443\u0437\u0430 \u043d\u0430 \u0433\u043b\u0430\u0437\u0430\u0445 \u0443 \u0434\u0440\u043e\u043d\u0442\u0430");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.WHY_YOU_CALL_ME_THIS_WAY, "Why You Call Me This Way?", "Rename the Deinonychus to \"Die-non-ih-kuss\" with a Name Tag");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.WHY_YOU_CALL_ME_THIS_WAY, "\u041d\u0435 \u043d\u0430\u0437\u044b\u0432\u0430\u0439 \u043c\u0435\u043d\u044f \u0442\u0430\u043a", "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u0443\u0439\u0442\u0435 \u0434\u0435\u0439\u043d\u043e\u043d\u0438\u0445\u0430 \u0432 \"\u0414\u0430\u043d\u0443\u043d\u0430\u0445\" \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0431\u0438\u0440\u043a\u0438");
        this.addAdvancement(DataProviderMultiLanguage.Language.ENGLISH, TDEAdvancements.NAIVETY_ITSELF, "Naivety Itself", "Meet the Dodo - the world's most naive bird");
        this.addAdvancement(DataProviderMultiLanguage.Language.RUSSIAN, TDEAdvancements.NAIVETY_ITSELF, "\u0421\u0430\u043c\u0430 \u043d\u0430\u0438\u0432\u043d\u043e\u0441\u0442\u044c", "\u041f\u043e\u0437\u043d\u0430\u043a\u043e\u043c\u044c\u0442\u0435\u0441\u044c \u0441 \u0434\u0440\u043e\u043d\u0442\u043e\u043c - \u0441\u0430\u043c\u043e\u0439 \u0434\u043e\u0432\u0435\u0440\u0447\u0438\u0432\u043e\u0439 \u043f\u0442\u0438\u0446\u0435\u0439 \u0432 \u043c\u0438\u0440\u0435");
    }

    private void registerSubtitles() {
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.idle", "Ceratosaurus growls");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.idle", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0443\u0440\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.sleep", "Ceratosaurus snores");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.sleep", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0445\u0440\u0430\u043f\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.attack", "Ceratosaurus bites");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.attack", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u043a\u0443\u0441\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.roar", "Ceratosaurus roars");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.roar", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0440\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.roar_strong", "Ceratosaurus roars frightening");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.roar_strong", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0436\u0443\u0442\u043a\u043e \u0440\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.hurt", "Ceratosaurus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.hurt", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.death", "Ceratosaurus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.death", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.ceratosaurus.step", "Ceratosaurus steps");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.ceratosaurus.step", "\u0426\u0435\u0440\u0430\u0442\u043e\u0437\u0430\u0432\u0440 \u0448\u0430\u0433\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.struthiomimus.idle", "Struthiomimus yells");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.struthiomimus.idle", "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c \u043a\u0443\u0434\u0430\u0445\u0447\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.struthiomimus.attack", "Struthiomimus attacking");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.struthiomimus.attack", "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.struthiomimus.scream", "Struthiomimus screaming");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.struthiomimus.scream", "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.struthiomimus.hurt", "Struthiomimus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.struthiomimus.hurt", "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.struthiomimus.death", "Struthiomimus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.struthiomimus.death", "\u0421\u0442\u0440\u0443\u0442\u0438\u043e\u043c\u0438\u043c \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.psittacosaurus.idle", "Psittacosaurus yells");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.psittacosaurus.idle", "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440 \u0432\u0441\u043a\u0440\u0438\u043a\u0438\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.psittacosaurus.attack", "Psittacosaurus attacking");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.psittacosaurus.attack", "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.psittacosaurus.scream", "Psittacosaurus screaming");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.psittacosaurus.scream", "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.psittacosaurus.hurt", "Psittacosaurus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.psittacosaurus.hurt", "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.psittacosaurus.death", "Psittacosaurus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.psittacosaurus.death", "\u041f\u0441\u0438\u0442\u0442\u0430\u043a\u043e\u0437\u0430\u0432\u0440 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.idle", "Diabloceratops hums");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.idle", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043c\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.attack", "Diabloceratops attacking");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.attack", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.scream", "Diabloceratops screaming");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.scream", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.hurt", "Diabloceratops hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.hurt", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.death", "Diabloceratops dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.death", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diabloceratops.step", "Diabloceratops steps");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diabloceratops.step", "\u0414\u0438\u0430\u0431\u043b\u043e\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0448\u0430\u0433\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.idle", "Triceratops hums");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.idle", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043c\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.attack", "Triceratops attacking");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.attack", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.scream", "Triceratops screaming");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.scream", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.hurt", "Triceratops hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.hurt", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.death", "Triceratops dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.death", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.triceratops.step", "Triceratops steps");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.triceratops.step", "\u0422\u0440\u0438\u0446\u0435\u0440\u0430\u0442\u043e\u043f\u0441 \u0448\u0430\u0433\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dunkleosteus.idle", "Dunkleosteus mumbles");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dunkleosteus.idle", "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439 \u0431\u043e\u0440\u043c\u043e\u0447\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dunkleosteus.attack", "Dunkleosteus bites");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dunkleosteus.attack", "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439 \u043a\u0443\u0441\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dunkleosteus.ram", "Dunkleosteus rams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dunkleosteus.ram", "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439 \u0431\u043e\u0434\u0430\u0435\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dunkleosteus.hurt", "Dunkleosteus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dunkleosteus.hurt", "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dunkleosteus.death", "Dunkleosteus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dunkleosteus.death", "\u0414\u0443\u043d\u043a\u043b\u0435\u043e\u0441\u0442\u0435\u0439 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.idle", "Dimorphodon yells");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.idle", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u0432\u0441\u043a\u0440\u0438\u043a\u0438\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.sleep", "Dimorphodon snores");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.sleep", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u0445\u0440\u0430\u043f\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.attack", "Dimorphodon bites");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.attack", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u043a\u0443\u0441\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.hurt", "Dimorphodon hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.hurt", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.death", "Dimorphodon dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.death", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dimorphodon.scream", "Dimorphodon screams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dimorphodon.scream", "\u0414\u0438\u043c\u043e\u0440\u0444\u043e\u0434\u043e\u043d \u0432\u0438\u0437\u0436\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.idle", "Tyrannosaurus growls");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.idle", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0443\u0440\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.sleep", "Tyrannosaurus snores");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.sleep", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0445\u0440\u0430\u043f\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.attack", "Tyrannosaurus attacking");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.attack", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.attack_ground", "Tyrannosaurus smashes ground");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.attack_ground", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0440\u0430\u0437\u0431\u0438\u0432\u0430\u0435\u0442 \u0437\u0435\u043c\u043b\u044e");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.ram", "Tyrannosaurus rams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.ram", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0431\u043e\u0434\u0430\u0435\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.yawn", "Tyrannosaurus yawns");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.yawn", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0437\u0435\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.sniff", "Tyrannosaurus sniffs");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.sniff", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u043f\u0440\u0438\u043d\u044e\u0445\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.roar", "Tyrannosaurus roars");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.roar", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0440\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.hurt", "Tyrannosaurus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.hurt", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.death", "Tyrannosaurus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.death", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.tyrannosaurus.step", "Tyrannosaurus steps");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.tyrannosaurus.step", "\u0422\u0438\u0440\u0430\u043d\u043d\u043e\u0437\u0430\u0432\u0440 \u0448\u0430\u0433\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.mixosaurus.idle", "Mixosaurus squeaks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.mixosaurus.idle", "\u041c\u0438\u043a\u0441\u043e\u0437\u0430\u0432\u0440 \u043f\u0438\u0449\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.mixosaurus.hurt", "Mixosaurus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.mixosaurus.hurt", "\u041c\u0438\u043a\u0441\u043e\u0437\u0430\u0432\u0440 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.mixosaurus.death", "Mixosaurus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.mixosaurus.death", "\u041c\u0438\u043a\u0441\u043e\u0437\u0430\u0432\u0440 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dodo.idle", "Dodo clucks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dodo.idle", "\u0414\u0440\u043e\u043d\u0442 \u043a\u0443\u0434\u0430\u0445\u0447\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dodo.hurt", "Dodo hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dodo.hurt", "\u0414\u0440\u043e\u043d\u0442 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dodo.death", "Dodo dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dodo.death", "\u0414\u0440\u043e\u043d\u0442 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.dodo.scream", "Dodo screams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.dodo.scream", "\u0414\u0440\u043e\u043d\u0442 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.idle", "Deinonychus yells");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.idle", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u0432\u0441\u043a\u0440\u0438\u043a\u0438\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.scream", "Deinonychus screams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.scream", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.call", "Deinonychus calls");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.call", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u0437\u0430\u0437\u044b\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.attack", "Deinonychus attacks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.attack", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.bite", "Deinonychus bites");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.bite", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u043a\u0443\u0441\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.jump", "Deinonychus jumps");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.jump", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u043d\u0430\u043f\u0440\u044b\u0433\u0438\u0432\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.hurt", "Deinonychus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.hurt", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.deinonychus.death", "Deinonychus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.deinonychus.death", "\u0414\u0435\u0439\u043d\u043e\u043d\u0438\u0445 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diplocaulus.idle", "Diplocaulus squeaks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diplocaulus.idle", "\u0414\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441 \u043f\u0438\u0449\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diplocaulus.scream", "Diplocaulus screams");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diplocaulus.scream", "\u0414\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441 \u043a\u0440\u0438\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diplocaulus.hurt", "Diplocaulus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diplocaulus.hurt", "\u0414\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.diplocaulus.death", "Diplocaulus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.diplocaulus.death", "\u0414\u0438\u043f\u043b\u043e\u043a\u0430\u0443\u043b\u0443\u0441 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.idle", "Sachicasaurus howls");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.idle", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0432\u043e\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.roar", "Sachicasaurus roars");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.roar", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0440\u044b\u0447\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.jaw_open", "Sachicasaurus opened his jaws");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.jaw_open", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0440\u0430\u0441\u043a\u0440\u044b\u043b \u043f\u0430\u0441\u0442\u044c");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.jaw_close", "Sachicasaurus closed his jaws");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.jaw_close", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0437\u0430\u043a\u0440\u044b\u043b \u043f\u0430\u0441\u0442\u044c");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.attack", "Sachicasaurus attacks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.attack", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0430\u0442\u0430\u043a\u0443\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.hurt", "Sachicasaurus hurts");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.hurt", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "entity.sachicasaurus.death", "Sachicasaurus dies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "entity.sachicasaurus.death", "\u0421\u0430\u0447\u0438\u043a\u0430\u0437\u0430\u0432\u0440 \u0443\u043c\u0438\u0440\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "block.egg.break", "Egg cracks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "block.egg.break", "\u042f\u0439\u0446\u043e \u0442\u0440\u0435\u0441\u043a\u0430\u0435\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "item.bone_whistle.use", "Whistle blows");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "item.bone_whistle.use", "\u0414\u0443\u0435\u0442 \u0432 \u0441\u0432\u0438\u0441\u0442\u043e\u043a");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "item.boomerang.throw", "Boomerang thrown");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "item.boomerang.throw", "\u0411\u0443\u043c\u0435\u0440\u0430\u043d\u0433 \u043a\u0438\u043d\u0443\u043b\u0438");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "item.boomerang.ground_impact", "Boomerang lands");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "item.boomerang.ground_impact", "\u0411\u0443\u043c\u0435\u0440\u0430\u043d\u0433 \u043f\u0440\u0438\u0437\u0435\u043c\u043b\u044f\u0435\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "item.boomerang.fly", "Boomerang flies");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "item.boomerang.fly", "\u0411\u0443\u043c\u0435\u0440\u0430\u043d\u0433 \u043b\u0435\u0442\u0438\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "effect.fracture", "Bones cracks");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "effect.fracture", "\u041a\u043e\u0441\u0442\u0438 \u043b\u043e\u043c\u0430\u044e\u0442\u0441\u044f");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "generic.eat", "Chews something");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "generic.eat", "\u0427\u0442\u043e-\u0442\u043e \u0436\u0443\u0451\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "misc.tree.fall", "Tree falls");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "misc.tree.fall", "\u0414\u0435\u0440\u0435\u0432\u043e \u043f\u0430\u0434\u0430\u0435\u0442");
        this.addSubtitle(DataProviderMultiLanguage.Language.ENGLISH, "misc.blood.land", "Blood dripping");
        this.addSubtitle(DataProviderMultiLanguage.Language.RUSSIAN, "misc.blood.land", "\u041a\u0440\u043e\u0432\u044c \u043a\u0430\u043f\u0430\u0435\u0442");
    }

    protected void addAdvancement(DataProviderMultiLanguage.Language language, ResourceLocation advancementId, String name, String advancementDescription) {
        this.add(language, "advancements.dawnera." + advancementId.m_135815_() + ".title", name);
        this.add(language, "advancements.dawnera." + advancementId.m_135815_() + ".description", advancementDescription);
    }

    protected void addMobOrder(DataProviderMultiLanguage.Language language, MobOrder action, String orderName, String message) {
        this.add(language, action.getName(), orderName);
        if (message != null) {
            this.add(language, action.getMessage(), message);
        }
    }

    protected void addGender(DataProviderMultiLanguage.Language language, GenderType genderType, String value) {
        this.add(language, genderType.getId(), value);
    }

    protected void addSubtitle(DataProviderMultiLanguage.Language language, String subtitle, String value) {
        this.add(language, "subtitles.dawnera." + subtitle, value);
    }

    protected void addCreativeTab(DataProviderMultiLanguage.Language language, RegistryObject<CreativeModeTab> tab, String value) {
        this.add(language, Util.m_137492_((String)"tab", (ResourceLocation)tab.getId()), value);
    }
}

