/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.utils.TDEItemUtils;

public class TDELootTableProvider
extends LootTableProvider {
    public TDELootTableProvider(boolean run, DataGenerator generator) {
        super(generator.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockProvider::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(EntityProvider::new, LootContextParamSets.f_81415_)));
        generator.addProvider(run, (DataProvider)this);
    }

    public static class BlockProvider
    extends BlockLootSubProvider {
        protected BlockProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.STURGEON_ROE);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.SABERTOOTH_SALMON_ROE);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.ALLIGATOR_GAR_ROE);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DIPLOCAULUS_ROE);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DUNKLEOSTEUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.CERATOSAURUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DIMORPHODON_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DIABLOCERATOPS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.TYRANNOSAURUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.TRICERATOPS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.STRUTHIOMIMUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.PSITTACOSAURUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DEINONYCHUS_EGG);
            this.silkTouch((Supplier<? extends Block>)TDEBlocks.DODO_EGG);
            this.dropSilkTouchOr((Supplier<? extends Block>)TDEBlocks.WORM_DIRT, Blocks.f_50493_);
            this.shearsOnly((Supplier<? extends Block>)TDEBlocks.SEAGRASS_EGGS);
            this.shearsOnlyDoublePlant((Supplier<? extends Block>)TDEBlocks.TALL_SEAGRASS_EGGS);
        }

        private void dropSilkTouchOr(Supplier<? extends Block> supplier, Block noSilkTouchBlock) {
            this.m_245854_(supplier.get(), noSilkTouchBlock);
        }

        private void silkTouch(Supplier<? extends Block> supplier) {
            this.m_245644_(supplier.get());
        }

        private void shearsOnly(Supplier<? extends Block> supplier) {
            this.m_247577_(supplier.get(), BlockProvider.m_245929_((ItemLike)((ItemLike)supplier.get())));
        }

        private void shearsOnlyDoublePlant(Supplier<? extends Block> supplier) {
            this.m_247577_(supplier.get(), BlockProvider.m_245929_((ItemLike)((ItemLike)supplier.get())));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TDEBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }
    }

    public static class EntityProvider
    extends EntityLootSubProvider {
        protected EntityProvider() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)TDEEntities.SACHICASAURUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.DUNKLEOSTEUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.CERATOSAURUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.MIXOSAURUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.POND_SNAIL.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.DIABLOCERATOPS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.DIMORPHODON.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.TYRANNOSAURUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.DEINONYCHUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.DIPLOCAULUS.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)TDEEntities.AEGIROCASSIS.get(), LootTable.m_79147_());
            this.addFishLikeDrop((Supplier<? extends EntityType>)TDEEntities.ALLIGATOR_GAR, (Supplier<? extends Item>)TDEItems.RAW_ALLIGATOR_GAR);
            this.addFishLikeDrop((Supplier<? extends EntityType>)TDEEntities.COELACANTH, (Supplier<? extends Item>)TDEItems.RAW_COELACANTH);
            this.addFishLikeDrop((Supplier<? extends EntityType>)TDEEntities.SABERTOOTH_SALMON, (Supplier<? extends Item>)TDEItems.RAW_SABERTOOTH_SALMON);
            this.addFishLikeDrop((Supplier<? extends EntityType>)TDEEntities.STURGEON, (Supplier<? extends Item>)TDEItems.RAW_STURGEON);
            this.addMeatDrop((Supplier<? extends EntityType>)TDEEntities.PSITTACOSAURUS, (Supplier<? extends Item>)TDEItems.PSITTACOSAURUS_MEAT);
            this.addChickenLikeDrop((Supplier<? extends EntityType>)TDEEntities.STRUTHIOMIMUS, (Supplier<? extends Item>)TDEItems.STRUTHIOMIMUS_MEAT);
            this.addChickenLikeDrop((Supplier<? extends EntityType>)TDEEntities.DODO, (Supplier<? extends Item>)TDEItems.RAW_DODO);
            this.add((Supplier<? extends EntityType>)TDEEntities.TRICERATOPS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TDEItems.TRICERATOPS_HORN.get())))));
            this.add((Supplier<? extends EntityType>)TDEEntities.WORM, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)TDEItems.WORM.get())))));
        }

        public void addMeatDrop(Supplier<? extends EntityType> supplier, Supplier<? extends Item> meatItem) {
            this.m_245309_(supplier.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)meatItem.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        public void addChickenLikeDrop(Supplier<? extends EntityType> supplier, Supplier<? extends Item> meatItem) {
            this.m_245309_(supplier.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)TDEItemUtils.tagVariation(ForgeRegistries.ENTITY_TYPES.getKey((Object)supplier.get())))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)meatItem.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        public void addFishLikeDrop(Supplier<? extends EntityType> supplier, Supplier<? extends Item> meatItem) {
            this.m_245309_(supplier.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)meatItem.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
        }

        public void add(Supplier<? extends EntityType> supplier, LootTable.Builder builder) {
            this.m_245309_(supplier.get(), builder);
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return TDEEntities.ENTITIES.getEntries().stream().map(RegistryObject::get);
        }
    }
}

