/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.datagen;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class TDESoundProvider
extends SoundDefinitionsProvider {
    protected TDESoundProvider(boolean run, DataGenerator generator, ExistingFileHelper helper) {
        super(generator.getPackOutput(), "dawnera", helper);
        generator.addProvider(run, (DataProvider)this);
    }

    public void registerSounds() {
        this.registerItemSounds();
        this.registerBlockSounds();
        this.registerMobSounds();
        this.registerOtherSounds();
    }

    private void registerMobSounds() {
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_IDLE, "entity.ceratosaurus.idle", "mob/ceratosaurus/idle0", "mob/ceratosaurus/idle1", "mob/ceratosaurus/idle2", "mob/ceratosaurus/idle3");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_SLEEP, "entity.ceratosaurus.sleep", "mob/ceratosaurus/sleep0", "mob/ceratosaurus/sleep1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_ATTACK, "entity.ceratosaurus.attack", "mob/ceratosaurus/attack0", "mob/ceratosaurus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_ROAR, "entity.ceratosaurus.roar", "mob/ceratosaurus/roar0", "mob/ceratosaurus/roar1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_ROAR_STRONG, "entity.ceratosaurus.roar_strong", "mob/ceratosaurus/roar_strong");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_HURT, "entity.ceratosaurus.hurt", "mob/ceratosaurus/hurt0", "mob/ceratosaurus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_DEATH, "entity.ceratosaurus.death", "mob/ceratosaurus/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.CERATOSAURUS_STEP, "entity.ceratosaurus.step", "mob/ceratosaurus/step0", "mob/ceratosaurus/step1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.STRUTHIOMIMUS_IDLE, "entity.struthiomimus.idle", "mob/struthiomimus/idle0", "mob/struthiomimus/idle1", "mob/struthiomimus/idle2", "mob/struthiomimus/idle3", "mob/struthiomimus/idle4", "mob/struthiomimus/idle5", "mob/struthiomimus/idle6", "mob/struthiomimus/idle7");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.STRUTHIOMIMUS_ATTACK, "entity.struthiomimus.attack", "mob/struthiomimus/attack0", "mob/struthiomimus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.STRUTHIOMIMUS_SCREAM, "entity.struthiomimus.scream", "mob/struthiomimus/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.STRUTHIOMIMUS_HURT, "entity.struthiomimus.hurt", "mob/struthiomimus/hurt0", "mob/struthiomimus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.STRUTHIOMIMUS_DEATH, "entity.struthiomimus.death", "mob/struthiomimus/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.PSITTACOSAURUS_IDLE, "entity.psittacosaurus.idle", "mob/psittacosaurus/idle0", "mob/psittacosaurus/idle1", "mob/psittacosaurus/idle2", "mob/psittacosaurus/idle3");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.PSITTACOSAURUS_ATTACK, "entity.psittacosaurus.attack", "mob/psittacosaurus/attack0", "mob/psittacosaurus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.PSITTACOSAURUS_SCREAM, "entity.psittacosaurus.scream", "mob/psittacosaurus/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.PSITTACOSAURUS_HURT, "entity.psittacosaurus.hurt", "mob/psittacosaurus/hurt0", "mob/psittacosaurus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.PSITTACOSAURUS_DEATH, "entity.psittacosaurus.death", "mob/psittacosaurus/death0", "mob/psittacosaurus/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_IDLE, "entity.diabloceratops.idle", "mob/diabloceratops/idle0", "mob/diabloceratops/idle1", "mob/diabloceratops/idle2", "mob/diabloceratops/idle3", "mob/diabloceratops/idle4");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_ATTACK, "entity.diabloceratops.attack", "mob/diabloceratops/attack0", "mob/diabloceratops/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_SCREAM, "entity.diabloceratops.scream", "mob/diabloceratops/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_HURT, "entity.diabloceratops.hurt", "mob/diabloceratops/hurt");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_DEATH, "entity.diabloceratops.death", "mob/diabloceratops/death0", "mob/diabloceratops/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIABLOCERATOPS_STEP, "entity.diabloceratops.step", "mob/diabloceratops/step0", "mob/diabloceratops/step1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_IDLE, "entity.triceratops.idle", "mob/triceratops/idle0", "mob/triceratops/idle1", "mob/triceratops/idle2", "mob/triceratops/idle3", "mob/triceratops/idle4");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_ATTACK, "entity.triceratops.attack", "mob/triceratops/attack0", "mob/triceratops/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_SCREAM, "entity.triceratops.scream", "mob/triceratops/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_HURT, "entity.triceratops.hurt", "mob/triceratops/hurt0", "mob/triceratops/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_DEATH, "entity.triceratops.death", "mob/triceratops/death0", "mob/triceratops/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TRICERATOPS_STEP, "entity.triceratops.step", "mob/triceratops/step0", "mob/triceratops/step1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DUNKLEOSTEUS_IDLE, "entity.dunkleosteus.idle", "mob/dunkleosteus/idle0", "mob/dunkleosteus/idle1", "mob/dunkleosteus/idle2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DUNKLEOSTEUS_ATTACK, "entity.dunkleosteus.attack", "mob/dunkleosteus/attack0", "mob/dunkleosteus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DUNKLEOSTEUS_RAM, "entity.dunkleosteus.ram", "mob/dunkleosteus/ram0", "mob/dunkleosteus/ram1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DUNKLEOSTEUS_HURT, "entity.dunkleosteus.hurt", "mob/dunkleosteus/hurt0", "mob/dunkleosteus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DUNKLEOSTEUS_DEATH, "entity.dunkleosteus.death", "mob/dunkleosteus/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_IDLE, "entity.dimorphodon.idle", "mob/dimorphodon/idle0", "mob/dimorphodon/idle1", "mob/dimorphodon/idle2", "mob/dimorphodon/idle3", "mob/dimorphodon/idle4", "mob/dimorphodon/idle5");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_SLEEP, "entity.dimorphodon.sleep", "mob/dimorphodon/sleep0", "mob/dimorphodon/sleep1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_ATTACK, "entity.dimorphodon.attack", "mob/dimorphodon/attack0", "mob/dimorphodon/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_SCREAM, "entity.dimorphodon.scream", "mob/dimorphodon/death0", "mob/dimorphodon/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_HURT, "entity.dimorphodon.hurt", "mob/dimorphodon/hurt0", "mob/dimorphodon/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIMORPHODON_DEATH, "entity.dimorphodon.death", "mob/dimorphodon/death0", "mob/dimorphodon/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_IDLE, "entity.tyrannosaurus.idle", "mob/tyrannosaurus/idle0", "mob/tyrannosaurus/idle1", "mob/tyrannosaurus/idle2", "mob/tyrannosaurus/idle3");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_SLEEP, "entity.tyrannosaurus.sleep", "mob/tyrannosaurus/sleep0", "mob/tyrannosaurus/sleep1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_ATTACK, "entity.tyrannosaurus.attack", "mob/tyrannosaurus/attack0", "mob/tyrannosaurus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_RAM, "entity.tyrannosaurus.ram", "mob/tyrannosaurus/ram");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_YAWN, "entity.tyrannosaurus.yawn", "mob/tyrannosaurus/yawn");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_SNIFF, "entity.tyrannosaurus.sniff", "mob/tyrannosaurus/sniff");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_ROAR, "entity.tyrannosaurus.roar", "mob/tyrannosaurus/roar0", "mob/tyrannosaurus/roar1", "mob/tyrannosaurus/roar2", "mob/tyrannosaurus/roar3", "mob/tyrannosaurus/roar4");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_HURT, "entity.tyrannosaurus.hurt", "mob/tyrannosaurus/hurt0", "mob/tyrannosaurus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_DEATH, "entity.tyrannosaurus.death", "mob/tyrannosaurus/death0", "mob/tyrannosaurus/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_ATTACK_GROUND, "entity.tyrannosaurus.attack_ground", "mob/tyrannosaurus/attack_ground");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TYRANNOSAURUS_STEP, "entity.tyrannosaurus.step", "mob/tyrannosaurus/step0", "mob/tyrannosaurus/step1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.MIXOSAURUS_IDLE, "entity.mixosaurus.idle", "mob/mixosaurus/idle0", "mob/mixosaurus/idle1", "mob/mixosaurus/idle2", "mob/mixosaurus/idle3");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.MIXOSAURUS_HURT, "entity.mixosaurus.hurt", "mob/mixosaurus/hurt0", "mob/mixosaurus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.MIXOSAURUS_DEATH, "entity.mixosaurus.death", "mob/mixosaurus/death0", "mob/mixosaurus/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DODO_IDLE, "entity.dodo.idle", "mob/dodo/idle0", "mob/dodo/idle1", "mob/dodo/idle2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DODO_HURT, "entity.dodo.hurt", "mob/dodo/hurt");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DODO_DEATH, "entity.dodo.death", "mob/dodo/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DODO_SCREAM, "entity.dodo.scream", "mob/dodo/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_IDLE, "entity.deinonychus.idle", "mob/deinonychus/idle0", "mob/deinonychus/idle1", "mob/deinonychus/idle2", "mob/deinonychus/idle3", "mob/deinonychus/idle4");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_SCREAM, "entity.deinonychus.scream", "mob/deinonychus/scream0", "mob/deinonychus/scream1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_CALL, "entity.deinonychus.call", "mob/deinonychus/call");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_ATTACK, "entity.deinonychus.attack", "mob/deinonychus/attack");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_BITE, "entity.deinonychus.bite", "mob/deinonychus/bite");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_JUMP, "entity.deinonychus.jump", "mob/deinonychus/jump");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_HURT, "entity.deinonychus.hurt", "mob/deinonychus/hurt0", "mob/deinonychus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DEINONYCHUS_DEATH, "entity.deinonychus.death", "mob/deinonychus/death0", "mob/deinonychus/death1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIPLOCAULUS_IDLE, "entity.diplocaulus.idle", "mob/diplocaulus/idle0", "mob/diplocaulus/idle1", "mob/diplocaulus/idle2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIPLOCAULUS_SCREAM, "entity.diplocaulus.scream", "mob/diplocaulus/scream");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIPLOCAULUS_HURT, "entity.diplocaulus.hurt", "mob/diplocaulus/hurt");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.DIPLOCAULUS_DEATH, "entity.diplocaulus.death", "mob/diplocaulus/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_IDLE, "entity.sachicasaurus.idle", "mob/sachicasaurus/idle0", "mob/sachicasaurus/idle1", "mob/sachicasaurus/idle2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_IDLE_UNDERWATER, "entity.sachicasaurus.idle", "mob/sachicasaurus/idle0_underwater", "mob/sachicasaurus/idle1_underwater", "mob/sachicasaurus/idle2_underwater", "mob/sachicasaurus/idle3_underwater");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_ATTACK, "entity.sachicasaurus.attack", "mob/sachicasaurus/attack0", "mob/sachicasaurus/attack1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_ATTACK_OTHER, "entity.sachicasaurus.attack", "mob/sachicasaurus/attack_other");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_HURT, "entity.sachicasaurus.hurt", "mob/sachicasaurus/hurt0", "mob/sachicasaurus/hurt1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_HURT_UNDERWATER, "entity.sachicasaurus.hurt", "mob/sachicasaurus/hurt0_underwater", "mob/sachicasaurus/hurt1_underwater");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_JAW_OPEN, "entity.sachicasaurus.jaw_open", "mob/sachicasaurus/jaw_open");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_JAW_CLOSE, "entity.sachicasaurus.jaw_close", "mob/sachicasaurus/jaw_close");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_ROAR, "entity.sachicasaurus.roar", "mob/sachicasaurus/roar0", "mob/sachicasaurus/roar1", "mob/sachicasaurus/roar2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_ROAR_UNDERWATER, "entity.sachicasaurus.roar", "mob/sachicasaurus/roar0_underwater", "mob/sachicasaurus/roar1_underwater", "mob/sachicasaurus/roar2_underwater");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_DEATH, "entity.sachicasaurus.death", "mob/sachicasaurus/death");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.SACHICASAURUS_DEATH_UNDERWATER, "entity.sachicasaurus.death", "mob/sachicasaurus/death_underwater");
    }

    private void registerBlockSounds() {
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.EGG_BREAK, "block.egg.break", "block/egg/break0", "block/egg/break1");
        this.registerSoundWithoutSubs((Supplier<SoundEvent>)TDESoundEvents.EGG_FALL, "block/egg/fall");
        this.registerSoundVanillaSubs((Supplier<SoundEvent>)TDESoundEvents.EGG_HIT, "block.generic.hit", "block/egg/hit0", "block/egg/hit1");
        this.registerSoundVanillaSubs((Supplier<SoundEvent>)TDESoundEvents.EGG_PLACE, "block.generic.place", "block/egg/place0", "block/egg/place1");
        this.registerSoundVanillaSubs((Supplier<SoundEvent>)TDESoundEvents.EGG_STEP, "block.generic.footsteps", "block/egg/step0", "block/egg/step1");
    }

    private void registerItemSounds() {
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BONE_WHISTLE_FOLLOW, "item.bone_whistle.use", "item/whistle0");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BONE_WHISTLE_WAIT, "item.bone_whistle.use", "item/whistle1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BOOMERANG_THROW, "item.boomerang.throw", "item/boomerang/throw0", "item/boomerang/throw1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BOOMERANG_GROUND_IMPACT, "item.boomerang.ground_impact", "item/boomerang/ground_impact0", "item/boomerang/ground_impact1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BOOMERANG_FLY, "item.boomerang.fly", "item/boomerang/fly0", "item/boomerang/fly1", "item/boomerang/fly2", "item/boomerang/fly3");
    }

    private void registerOtherSounds() {
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.FRACTURE, "effect.fracture", "effect/fracture0", "effect/fracture1", "effect/fracture2", "effect/fracture3");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.TREE_FALL, "misc.tree.fall", "misc/tree_fall0", "misc/tree_fall1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.BLOOD_LAND, "misc.blood.land", "misc/blood_land0", "misc/blood_land1", "misc/blood_land2");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.EAT_GRASS, "generic.eat", "generic/eat/grass0");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.EAT_MEAT, "generic.eat", "generic/eat/meat0", "generic/eat/meat1");
        this.registerSound((Supplier<SoundEvent>)TDESoundEvents.EAT_SHORT, "generic.eat", "generic/eat/short0", "generic/eat/short1");
    }

    private void registerSound(Supplier<SoundEvent> soundEvent, String subtitle, String ... sounds) {
        SoundDefinition def = TDESoundProvider.definition().subtitle("subtitles.dawnera." + subtitle);
        for (String sound : sounds) {
            def.with(TDESoundProvider.sound((ResourceLocation)new ResourceLocation("dawnera", sound)));
        }
        this.add(soundEvent, def);
    }

    private void registerSoundVanillaSubs(Supplier<SoundEvent> soundEvent, String subtitle, String ... sounds) {
        SoundDefinition def = TDESoundProvider.definition().subtitle("subtitles." + subtitle);
        for (String sound : sounds) {
            def.with(TDESoundProvider.sound((ResourceLocation)new ResourceLocation("dawnera", sound)));
        }
        this.add(soundEvent, def);
    }

    private void registerSoundWithoutSubs(Supplier<SoundEvent> soundEvent, String ... sounds) {
        SoundDefinition def = TDESoundProvider.definition();
        for (String sound : sounds) {
            def.with(TDESoundProvider.sound((ResourceLocation)new ResourceLocation("dawnera", sound)));
        }
        this.add(soundEvent, def);
    }
}

