/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.mixin;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.TDEMobCategory;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.io.config.TDECommonConfig;

@Mixin(value={NaturalSpawner.class})
public abstract class MixinNaturalSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long spawnTick = 0L;

    @Inject(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onSpawnCategoryForPosition(MobCategory category, ServerLevel level, ChunkAccess chunkAccess, BlockPos blockPos, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback, CallbackInfo ci) {
        if (TDEMobCategory.MOB_CATEGORIES.contains(category)) {
            if (++spawnTick % (long)((Integer)TDECommonConfig.MOB_SPAWN_INTERVAL.get()).intValue() == 0L) {
                MixinNaturalSpawner._spawnCategoryForPosition(category, level, chunkAccess, blockPos, spawnPredicate, afterSpawnCallback);
            }
            ci.cancel();
        }
    }

    private static void _spawnCategoryForPosition(MobCategory category, ServerLevel level, ChunkAccess chunkAccess, BlockPos blockPos, NaturalSpawner.SpawnPredicate spawnPredicate, NaturalSpawner.AfterSpawnCallback afterSpawnCallback) {
        StructureManager structuremanager = level.m_215010_();
        ChunkGenerator chunkgenerator = level.m_7726_().m_8481_();
        BlockState blockstate = chunkAccess.m_8055_(blockPos);
        if (!blockstate.m_60796_((BlockGetter)chunkAccess, blockPos)) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int spawnCountGlobal = 0;
            int posX = blockPos.m_123341_();
            int posY = blockPos.m_123342_();
            int posZ = blockPos.m_123343_();
            MobSpawnSettings.SpawnerData spawnerData = null;
            SpawnGroupData spawnGroupData = null;
            int spawnCount = RandomUtils.randomInt((int)1, (int)4);
            int spawnedCount = 0;
            for (int i = 0; i < spawnCount; ++i) {
                double d2;
                mutableBlockPos.m_122178_(posX += level.f_46441_.m_188503_(6) - level.f_46441_.m_188503_(6), posY, posZ += level.f_46441_.m_188503_(6) - level.f_46441_.m_188503_(6));
                double d0 = (double)posX + 0.5;
                double d1 = (double)posZ + 0.5;
                Player player = level.m_45924_(d0, (double)posY, d1, -1.0, false);
                if (player == null || !MixinNaturalSpawner._isRightDistanceToPlayerAndSpawnPoint(level, chunkAccess, mutableBlockPos, d2 = player.m_20275_(d0, (double)posY, d1))) continue;
                if (spawnerData == null) {
                    Optional<MobSpawnSettings.SpawnerData> optional = MixinNaturalSpawner._getRandomSpawnMobAt(level, structuremanager, chunkgenerator, category, level.f_46441_, (BlockPos)mutableBlockPos);
                    if (optional.isEmpty()) break;
                    spawnerData = optional.get();
                    spawnCount = spawnerData.f_48405_ + level.f_46441_.m_188503_(1 + spawnerData.f_48406_ - spawnerData.f_48405_);
                }
                if (!MixinNaturalSpawner._isValidSpawnPostitionForType(level, category, structuremanager, chunkgenerator, spawnerData, mutableBlockPos, d2) || !spawnPredicate.m_47106_(spawnerData.f_48404_, (BlockPos)mutableBlockPos, chunkAccess)) continue;
                Mob mob = MixinNaturalSpawner._getMobForSpawn(level, spawnerData.f_48404_);
                if (mob == null) {
                    return;
                }
                if (mob instanceof BaseAnimal) {
                    BaseAnimal baseAnimal = (BaseAnimal)mob;
                    if (i == 0 && !((MobProperties)baseAnimal.getProperties()).getMobSpawn().tryToSpawn(level.f_46441_)) {
                        return;
                    }
                }
                mob.m_7678_(d0, (double)posY, d1, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                if (!MixinNaturalSpawner._isValidPositionForMob(level, mob, d2)) continue;
                spawnGroupData = mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.NATURAL, spawnGroupData, null);
                ++spawnedCount;
                level.m_47205_((Entity)mob);
                afterSpawnCallback.m_47100_(mob, chunkAccess);
                if (++spawnCountGlobal >= ForgeEventFactory.getMaxSpawnPackSize((Mob)mob)) {
                    return;
                }
                if (mob.m_7296_(spawnedCount)) break;
            }
        }
    }

    private static boolean _isInNetherFortressBounds(BlockPos blockPos, ServerLevel serverLevel, MobCategory mobCategory, StructureManager structureManager) {
        if (mobCategory == MobCategory.MONSTER && serverLevel.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50197_)) {
            Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209859_);
            return structure == null ? false : structureManager.m_220494_(blockPos, structure).m_73603_();
        }
        return false;
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> _mobsAt(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, BlockPos blockPos, @Nullable Holder<Biome> biomeHolder) {
        return ForgeEventFactory.getPotentialSpawns((LevelAccessor)serverLevel, (MobCategory)mobCategory, (BlockPos)blockPos, (WeightedRandomList)(MixinNaturalSpawner._isInNetherFortressBounds(blockPos, serverLevel, mobCategory, structureManager) ? ((StructureSpawnOverride)((Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_123013_(BuiltinStructures.f_209859_)).m_226612_().get(MobCategory.MONSTER)).f_210044_() : chunkGenerator.m_223133_(biomeHolder != null ? biomeHolder : serverLevel.m_204166_(blockPos), structureManager, mobCategory, blockPos)));
    }

    private static boolean _isRightDistanceToPlayerAndSpawnPoint(ServerLevel serverLevel, ChunkAccess chunkAccess, BlockPos.MutableBlockPos mutableBlockPos, double distance) {
        if (distance <= 576.0) {
            return false;
        }
        if (serverLevel.m_220360_().m_203195_((Position)new Vec3((double)mutableBlockPos.m_123341_() + 0.5, (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkPos((BlockPos)mutableBlockPos), chunkAccess.m_7697_()) || serverLevel.m_201918_((BlockPos)mutableBlockPos);
    }

    private static boolean _canSpawnMobAt(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, MobSpawnSettings.SpawnerData spawnerData, BlockPos blockPos) {
        return MixinNaturalSpawner._mobsAt(serverLevel, structureManager, chunkGenerator, mobCategory, blockPos, null).m_146338_().contains(spawnerData);
    }

    private static Optional<MobSpawnSettings.SpawnerData> _getRandomSpawnMobAt(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, RandomSource randomSource, BlockPos blockPos) {
        Holder holder = serverLevel.m_204166_(blockPos);
        return mobCategory == MobCategory.WATER_AMBIENT && holder.m_203656_(BiomeTags.f_215811_) && randomSource.m_188501_() < 0.98f ? Optional.empty() : MixinNaturalSpawner._mobsAt(serverLevel, structureManager, chunkGenerator, mobCategory, blockPos, (Holder<Biome>)holder).m_216829_(randomSource);
    }

    private static boolean _isValidSpawnPostitionForType(ServerLevel serverLevel, MobCategory mobCategory, StructureManager structureManager, ChunkGenerator chunkGenerator, MobSpawnSettings.SpawnerData spawnerData, BlockPos.MutableBlockPos mutableBlockPos, double distance) {
        EntityType entitytype = spawnerData.f_48404_;
        if (entitytype.m_20674_() == MobCategory.MISC) {
            return false;
        }
        if (!entitytype.m_20673_() && distance > (double)(entitytype.m_20674_().m_21611_() * entitytype.m_20674_().m_21611_())) {
            return false;
        }
        if (entitytype.m_20654_() && MixinNaturalSpawner._canSpawnMobAt(serverLevel, structureManager, chunkGenerator, mobCategory, spawnerData, (BlockPos)mutableBlockPos)) {
            SpawnPlacements.Type placementType = SpawnPlacements.m_21752_((EntityType)entitytype);
            if (!MixinNaturalSpawner._isSpawnPositionOk(placementType, (LevelReader)serverLevel, (BlockPos)mutableBlockPos, entitytype)) {
                return false;
            }
            if (!SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)mutableBlockPos, (RandomSource)serverLevel.f_46441_)) {
                return false;
            }
            return serverLevel.m_45772_(entitytype.m_20585_((double)mutableBlockPos.m_123341_() + 0.5, (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_() + 0.5));
        }
        return false;
    }

    private static boolean _isSpawnPositionOk(SpawnPlacements.Type placementType, LevelReader level, BlockPos blockPos, @Nullable EntityType<?> entityType) {
        if (placementType == SpawnPlacements.Type.NO_RESTRICTIONS) {
            return true;
        }
        if (entityType != null && level.m_6857_().m_61937_(blockPos)) {
            return placementType.canSpawnAt(level, blockPos, entityType);
        }
        return false;
    }

    private static Mob _getMobForSpawn(ServerLevel serverLevel, EntityType<?> entityType) {
        try {
            Entity entity = entityType.m_20615_((Level)serverLevel);
            if (entity instanceof Mob) {
                return (Mob)entity;
            }
            LOGGER.warn("Can't spawn entity of type: {}", (Object)BuiltInRegistries.f_256780_.m_7981_(entityType));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to create mob", (Throwable)exception);
        }
        return null;
    }

    private static boolean _isValidPositionForMob(ServerLevel serverLevel, Mob mob, double despawnDistance) {
        if (despawnDistance > (double)(mob.m_6095_().m_20674_().m_21611_() * mob.m_6095_().m_20674_().m_21611_()) && mob.m_6785_(despawnDistance)) {
            return false;
        }
        return ForgeEventFactory.checkSpawnPosition((Mob)mob, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.NATURAL);
    }
}

