#version 150

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;

uniform float iTime;

in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 texColor = texture(Sampler0, texCoord0);
    if (texColor.a == 0.0) {
        discard;
    }
    vec4 shine_color = vec4(1.0);
    float shine_speed = 3.0;
    float factor = 1.0 - 0.001;
    float blur_amount = 0.05;
    float shine = smoothstep(factor*0.995,factor, 0.5 + 0.5 * sin(texCoord0.y - texCoord0.x + iTime * shine_speed));
    vec3 color = mix(texColor.rgb, shine_color.rgb, shine * shine_color.a);
    vec2 blur_direction = vec2(1.0, 1.0);
    vec4 blurred_color = vec4(1.0);
    for (float i = -5.0; i <= 5.0; i += 0.1) {
        vec2 offset = i * blur_direction * blur_amount;
        blurred_color += texture(Sampler0, texCoord0 + offset);
    }
    blurred_color /= 4.0;
    color = mix(color, blurred_color.rgb, step(0.9999, shine));
    fragColor = vec4(color, 1.0)*ColorModulator;
}
