/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaAntiExploit.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import me.TreeOfSelf.PandaAntiExploit.util.PandaLogger;

public class PandaConfig {
    public boolean doLogging = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final Combat combat = new Combat();
    public final Player player = new Player();
    public final BlockPlacement blockPlacement = new BlockPlacement();
    public final Packet packet = new Packet();

    public static PandaConfig loadConfig(File configFile) {
        PandaConfig pandaConfig;
        if (configFile.exists() && configFile.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(configFile);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                pandaConfig = (PandaConfig)GSON.fromJson((Reader)bufferedReader, PandaConfig.class);
            }
            catch (IOException e) {
                PandaLogger.logError("Problem occurred when trying to load config: " + e.getMessage());
                pandaConfig = new PandaConfig();
            }
        } else {
            pandaConfig = new PandaConfig();
        }
        pandaConfig.saveConfig(configFile);
        return pandaConfig;
    }

    public void saveConfig(File configFile) {
        try (FileOutputStream stream = new FileOutputStream(configFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            PandaLogger.logError("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public static class Combat {
        public boolean preventWallHit = true;
        public boolean checkHitDistance = true;
        public boolean checkHitAngle = true;
        public boolean fixAttributeSwap = true;
    }

    public static class Player {
        public boolean preventDeadPlayerActions = true;
    }

    public static class BlockPlacement {
        public boolean preventAirPlacement = true;
        public boolean checkPlacementDistance = true;
        public boolean preventThroughBlockPlacement = true;
        public boolean checkPlacementAngle = true;
        public boolean preventLongRangeBlockBreaking = true;
        public boolean preventLongRangeBlockUsage = true;
    }

    public static class Packet {
        public boolean removeTeleportData = true;
        public boolean removeHealthTags = true;
        public boolean removeHealthTagsFromMobs = true;
        public boolean removeEquipmentTags = true;
        public boolean removeDroppedItemTags = true;
        public boolean patchSoundExploits = true;
        public boolean patchSoundExploitsStrict = true;
        public boolean preventBlockBreakExploits = true;
        public boolean capNetherViewDistance = true;
        public boolean capNetherViewDistanceBuffer = false;
    }
}

