/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.behaviour.display;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.nbt.NBTProcessors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class DisplaySource {
    public static final SimpleRegistry.Multi<class_2248, DisplaySource> BY_BLOCK = SimpleRegistry.Multi.create();
    public static final SimpleRegistry.Multi<class_2591<?>, DisplaySource> BY_BLOCK_ENTITY = SimpleRegistry.Multi.create();
    public static final List<class_5250> EMPTY = ImmutableList.of((Object)class_2561.method_43473());
    public static final class_5250 EMPTY_LINE = class_2561.method_43473();
    public static final class_5250 WHITESPACE = class_5244.method_48320();

    public abstract List<class_5250> provideText(DisplayLinkContext var1, DisplayTargetStats var2);

    public void transferData(DisplayLinkContext context, DisplayTarget activeTarget, int line) {
        List<class_5250> text;
        DisplayTargetStats stats = activeTarget.provideStats(context);
        if (activeTarget instanceof DisplayBoardTarget) {
            DisplayBoardTarget fddt = (DisplayBoardTarget)activeTarget;
            List<List<class_5250>> flapDisplayText = this.provideFlapDisplayText(context, stats);
            fddt.acceptFlapText(line, flapDisplayText, context);
        }
        if ((text = this.provideText(context, stats)).isEmpty()) {
            text = EMPTY;
        }
        if (activeTarget.requiresComponentSanitization()) {
            for (class_5250 component : text) {
                if (!NBTProcessors.textComponentHasClickEvent((class_2561)component)) continue;
                return;
            }
        }
        activeTarget.acceptText(line, text, context);
    }

    public void onSignalReset(DisplayLinkContext context) {
    }

    public void populateData(DisplayLinkContext context) {
    }

    public int getPassiveRefreshTicks() {
        return 100;
    }

    public boolean shouldPassiveReset() {
        return true;
    }

    protected final class_2960 getId() {
        return CreateBuiltInRegistries.DISPLAY_SOURCE.method_10221((Object)this);
    }

    protected String getTranslationKey() {
        return this.getId().method_12832();
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)(this.getId().method_12836() + ".display_source." + this.getTranslationKey()));
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        this.loadFlapDisplayLayout(context, flapDisplay, layout);
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        if (!layout.isLayout("Default")) {
            layout.loadDefault(flapDisplay.getMaxCharCount());
        }
    }

    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        return this.provideText(context, stats).stream().map(xva$0 -> Arrays.asList(xva$0)).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
    }

    public static <B extends class_2248, P> NonNullUnaryOperator<BlockBuilder<B, P>> displaySource(RegistryEntry<? extends DisplaySource> source) {
        return builder -> (BlockBuilder)builder.onRegisterAfter(CreateRegistries.DISPLAY_SOURCE, block -> BY_BLOCK.add((class_2248)block, (DisplaySource)source.get()));
    }

    @Nullable
    public static DisplaySource get(@Nullable class_2960 id) {
        if (id == null) {
            return null;
        }
        if (id.method_12836().equals("create") && AllDisplaySources.LEGACY_NAMES.containsKey(id.method_12832())) {
            return (DisplaySource)AllDisplaySources.LEGACY_NAMES.get(id.method_12832()).get();
        }
        return (DisplaySource)CreateBuiltInRegistries.DISPLAY_SOURCE.method_10223(id);
    }

    public static List<DisplaySource> getAll(class_1936 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        Object byBlock = BY_BLOCK.get((class_2688)state);
        class_2586 be = level.method_8321(pos);
        if (be == null) {
            return byBlock;
        }
        Object byBe = BY_BLOCK_ENTITY.get(be.method_11017());
        if (byBlock.isEmpty()) {
            if (byBe.isEmpty()) {
                return List.of();
            }
            return byBe;
        }
        if (byBe.isEmpty()) {
            return byBlock;
        }
        ArrayList<DisplaySource> combined = new ArrayList<DisplaySource>((Collection<DisplaySource>)byBlock);
        combined.addAll((Collection<DisplaySource>)byBe);
        return combined;
    }
}

