/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.data.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class MechanicalCraftingRecipeBuilder {
    private final class_1792 result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private boolean acceptMirrored;
    private List<ConditionJsonProvider> recipeConditions;

    public MechanicalCraftingRecipeBuilder(class_1935 result, int resultCount) {
        this.result = result.method_8389();
        this.count = resultCount;
        this.acceptMirrored = true;
        this.recipeConditions = new ArrayList<ConditionJsonProvider>();
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(class_1935 result) {
        return MechanicalCraftingRecipeBuilder.shapedRecipe(result, 1);
    }

    public static MechanicalCraftingRecipeBuilder shapedRecipe(class_1935 result, int resultCount) {
        return new MechanicalCraftingRecipeBuilder(result, resultCount);
    }

    public MechanicalCraftingRecipeBuilder key(Character c, class_6862<class_1792> tag) {
        return this.key(c, class_1856.method_8106(tag));
    }

    public MechanicalCraftingRecipeBuilder key(Character c, class_1935 item) {
        return this.key(c, class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public MechanicalCraftingRecipeBuilder key(Character c, class_1856 ingredient) {
        if (this.key.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(c, ingredient);
        return this;
    }

    public MechanicalCraftingRecipeBuilder patternLine(String line) {
        if (!this.pattern.isEmpty() && line.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(line);
        return this;
    }

    public MechanicalCraftingRecipeBuilder disallowMirrored() {
        this.acceptMirrored = false;
        return this;
    }

    public void build(Consumer<class_2444> out) {
        this.build(out, CatnipServices.REGISTRIES.getKeyOrThrow(this.result));
    }

    public void build(Consumer<class_2444> out, String id) {
        class_2960 resourcelocation = CatnipServices.REGISTRIES.getKeyOrThrow(this.result);
        if (new class_2960(id).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + id + " should remove its 'id' argument");
        }
        this.build(out, new class_2960(id));
    }

    public void build(Consumer<class_2444> out, class_2960 id) {
        this.validate(id);
        out.accept(new Result(id, this.result, this.count, this.pattern, this.key, this.acceptMirrored, this.recipeConditions));
    }

    private void validate(class_2960 recipeId) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(recipeId) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(recipeId) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(recipeId));
        }
    }

    public MechanicalCraftingRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition(DefaultResourceConditions.allModsLoaded((String[])new String[]{modid}));
    }

    public MechanicalCraftingRecipeBuilder whenModMissing(String modid) {
        return this.withCondition(DefaultResourceConditions.not((ConditionJsonProvider)DefaultResourceConditions.allModsLoaded((String[])new String[]{modid})));
    }

    public MechanicalCraftingRecipeBuilder withCondition(ConditionJsonProvider condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final boolean acceptMirrored;
        private List<ConditionJsonProvider> recipeConditions;

        public Result(class_2960 recipeId, class_1792 result, int count, List<String> pattern, Map<Character, class_1856> key, boolean asymmetrical, List<ConditionJsonProvider> recipeConditions) {
            this.id = recipeId;
            this.result = result;
            this.count = count;
            this.pattern = pattern;
            this.key = key;
            this.acceptMirrored = asymmetrical;
            this.recipeConditions = recipeConditions;
        }

        public void method_10416(JsonObject o) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            o.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            o.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", CatnipServices.REGISTRIES.getKeyOrThrow(this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            o.add("result", (JsonElement)jsonObject);
            o.addProperty("acceptMirrored", Boolean.valueOf(this.acceptMirrored));
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray jsonArray = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)c.toJson()));
            o.add("conditions", (JsonElement)jsonArray);
        }

        public class_1865<?> method_17800() {
            return AllRecipeTypes.MECHANICAL_CRAFTING.getSerializer();
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

