/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.psi;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

public class PortableStorageInterfaceRenderer
extends SafeBlockEntityRenderer<PortableStorageInterfaceBlockEntity> {
    public PortableStorageInterfaceRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(PortableStorageInterfaceBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        class_2680 blockState = be.method_11010();
        float progress = be.getExtensionDistance(partialTicks);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        PortableStorageInterfaceRenderer.render(blockState, be.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        class_2680 blockState = context.state;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableStorageInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        PortableStorageInterfaceRenderer.render(blockState, lit, progress, matrices.getModel(), sbb -> sbb.light(class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos)).useLevelLight((class_1920)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), vb));
    }

    private static void render(class_2680 blockState, boolean lit, float progress, class_4587 local, Consumer<SuperByteBuffer> drawCallback) {
        SuperByteBuffer middle = CachedBuffers.partial((PartialModel)PortableStorageInterfaceRenderer.getMiddleForState(blockState, lit), (class_2680)blockState);
        SuperByteBuffer top = CachedBuffers.partial((PartialModel)PortableStorageInterfaceRenderer.getTopForState(blockState), (class_2680)blockState);
        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)PortableStorageInterfaceBlock.field_10927);
        PortableStorageInterfaceRenderer.rotateToFacing(middle, facing);
        PortableStorageInterfaceRenderer.rotateToFacing(top, facing);
        middle.translate(0.0f, progress * 0.5f + 0.375f, 0.0f);
        top.translate(0.0f, progress, 0.0f);
        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, class_2350 facing) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.center()).rotateYDegrees(AngleHelper.horizontalAngle((class_2350)facing))).rotateXDegrees(facing == class_2350.field_11036 ? 0.0f : (facing == class_2350.field_11033 ? 180.0f : 90.0f))).uncenter();
    }

    static PortableStorageInterfaceBlockEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.data.method_10545(_workingPos_)) {
            return null;
        }
        class_2338 pos = class_2512.method_10691((class_2487)context.data.method_10562(_workingPos_));
        class_2586 blockEntity = context.world.method_8321(pos);
        if (!(blockEntity instanceof PortableStorageInterfaceBlockEntity)) {
            return null;
        }
        PortableStorageInterfaceBlockEntity psi = (PortableStorageInterfaceBlockEntity)blockEntity;
        if (!psi.isTransferring()) {
            return null;
        }
        return psi;
    }

    static PartialModel getMiddleForState(class_2680 state, boolean lit) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return lit ? AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_FLUID_INTERFACE_MIDDLE;
        }
        return lit ? AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE_POWERED : AllPartialModels.PORTABLE_STORAGE_INTERFACE_MIDDLE;
    }

    static PartialModel getTopForState(class_2680 state) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return AllPartialModels.PORTABLE_FLUID_INTERFACE_TOP;
        }
        return AllPartialModels.PORTABLE_STORAGE_INTERFACE_TOP;
    }
}

