/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.sync;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class ContraptionSeatMappingPacket
extends SimplePacketBase {
    private Map<UUID, Integer> mapping;
    private int entityID;
    private int dismountedID;

    public ContraptionSeatMappingPacket(int entityID, Map<UUID, Integer> mapping) {
        this(entityID, mapping, -1);
    }

    public ContraptionSeatMappingPacket(int entityID, Map<UUID, Integer> mapping, int dismountedID) {
        this.entityID = entityID;
        this.mapping = mapping;
        this.dismountedID = dismountedID;
    }

    public ContraptionSeatMappingPacket(class_2540 buffer) {
        this.entityID = buffer.readInt();
        this.dismountedID = buffer.readInt();
        this.mapping = new HashMap<UUID, Integer>();
        int size = buffer.readShort();
        for (int i = 0; i < size; ++i) {
            this.mapping.put(buffer.method_10790(), Integer.valueOf(buffer.readShort()));
        }
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.dismountedID);
        buffer.writeShort(this.mapping.size());
        this.mapping.forEach((k, v) -> {
            buffer.method_10797(k);
            buffer.writeShort(v.intValue());
        });
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> {
            class_1297 entityByID = class_310.method_1551().field_1687.method_8469(this.entityID);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            if (this.dismountedID != -1) {
                class_1297 dismountedByID = class_310.method_1551().field_1687.method_8469(this.dismountedID);
                if (class_310.method_1551().field_1724 != dismountedByID) {
                    return;
                }
                class_243 transformedVector = contraptionEntity.getPassengerPosition(dismountedByID, 1.0f);
                if (transformedVector != null) {
                    dismountedByID.getCustomData().method_10566("ContraptionDismountLocation", (class_2520)VecHelper.writeNBT((class_243)transformedVector));
                }
            }
            contraptionEntity.getContraption().setSeatMapping(this.mapping);
        });
        return true;
    }
}

