/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.symmetryWand.mirror;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.simibubi.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_4587;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";
    protected class_243 position;
    protected class_3542 orientation;
    protected int orientationIndex;
    public boolean enable;
    private static final String $ORIENTATION = "direction";
    private static final String $POSITION = "pos";
    private static final String $TYPE = "type";
    private static final String $ENABLE = "enable";

    public SymmetryMirror(class_243 pos) {
        this.position = pos;
        this.enable = true;
        this.orientationIndex = 0;
    }

    public static List<class_2561> getMirrors() {
        return ImmutableList.of((Object)CreateLang.translateDirect("symmetry.mirror.plane", new Object[0]), (Object)CreateLang.translateDirect("symmetry.mirror.doublePlane", new Object[0]), (Object)CreateLang.translateDirect("symmetry.mirror.triplePlane", new Object[0]));
    }

    public class_3542 getOrientation() {
        return this.orientation;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public int getOrientationIndex() {
        return this.orientationIndex;
    }

    public void rotate(boolean forward) {
        this.orientationIndex += forward ? 1 : -1;
        this.setOrientation();
    }

    public void process(Map<class_2338, class_2680> blocks) {
        HashMap<class_2338, class_2680> result = new HashMap<class_2338, class_2680>();
        for (class_2338 pos : blocks.keySet()) {
            result.putAll(this.process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public abstract Map<class_2338, class_2680> process(class_2338 var1, class_2680 var2);

    protected abstract void setOrientation();

    public abstract void setOrientation(int var1);

    public abstract String typeName();

    @Environment(value=EnvType.CLIENT)
    public abstract PartialModel getModel();

    public void applyModelTransform(class_4587 ms) {
    }

    public class_2487 writeToNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569($ORIENTATION, this.orientationIndex);
        class_2499 floatList = new class_2499();
        floatList.add((Object)class_2494.method_23244((float)((float)this.position.field_1352)));
        floatList.add((Object)class_2494.method_23244((float)((float)this.position.field_1351)));
        floatList.add((Object)class_2494.method_23244((float)((float)this.position.field_1350)));
        nbt.method_10566($POSITION, (class_2520)floatList);
        nbt.method_10582($TYPE, this.typeName());
        nbt.method_10556($ENABLE, this.enable);
        return nbt;
    }

    public static SymmetryMirror fromNBT(class_2487 nbt) {
        class_2499 floatList = nbt.method_10554($POSITION, 5);
        class_243 pos = new class_243((double)floatList.method_10604(0), (double)floatList.method_10604(1), (double)floatList.method_10604(2));
        SymmetryMirror element = switch (nbt.method_10558($TYPE)) {
            case PLANE -> new PlaneMirror(pos);
            case CROSS_PLANE -> new CrossPlaneMirror(pos);
            case TRIPLE_PLANE -> new TriplePlaneMirror(pos);
            default -> new EmptyMirror(pos);
        };
        element.setOrientation(nbt.method_10550($ORIENTATION));
        element.enable = nbt.method_10577($ENABLE);
        return element;
    }

    protected class_243 getDiff(class_2338 position) {
        return this.position.method_1021(-1.0).method_1031((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260());
    }

    protected class_2338 getIDiff(class_2338 position) {
        class_243 diff = this.getDiff(position);
        return new class_2338((int)diff.field_1352, (int)diff.field_1351, (int)diff.field_1350);
    }

    protected class_2680 flipX(class_2680 in) {
        return in.method_26185(class_2415.field_11301);
    }

    protected class_2680 flipY(class_2680 in) {
        for (class_2769 property : in.method_28501()) {
            if (property == class_2741.field_12518) {
                return (class_2680)in.method_28493(property);
            }
            if (!(property instanceof class_2753)) continue;
            if (in.method_11654(property) == class_2350.field_11033) {
                return (class_2680)in.method_11657((class_2769)((class_2753)property), (Comparable)class_2350.field_11036);
            }
            if (in.method_11654(property) != class_2350.field_11036) continue;
            return (class_2680)in.method_11657((class_2769)((class_2753)property), (Comparable)class_2350.field_11033);
        }
        return in;
    }

    protected class_2680 flipZ(class_2680 in) {
        return in.method_26185(class_2415.field_11300);
    }

    protected class_2680 flipD1(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11301);
    }

    protected class_2680 flipD2(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11300);
    }

    protected class_2338 flipX(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - 2 * diff.method_10263(), position.method_10264(), position.method_10260());
    }

    protected class_2338 flipY(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264() - 2 * diff.method_10264(), position.method_10260());
    }

    protected class_2338 flipZ(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264(), position.method_10260() - 2 * diff.method_10260());
    }

    protected class_2338 flipD2(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() + diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() + diff.method_10263());
    }

    protected class_2338 flipD1(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() - diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() - diff.method_10263());
    }

    public void setPosition(class_243 pos3d) {
        this.position = pos3d;
    }

    public abstract List<class_2561> getAlignToolTips();
}

