/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gearbox;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class GearboxVisual
extends KineticBlockEntityVisual<GearboxBlockEntity> {
    protected final EnumMap<class_2350, RotatingInstance> keys = new EnumMap(class_2350.class);
    protected class_2350 sourceFacing;

    public GearboxVisual(VisualizationContext context, GearboxBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        class_2350.class_2351 boxAxis = (class_2350.class_2351)this.blockState.method_11654((class_2769)class_2741.field_12496);
        this.updateSourceFacing();
        Instancer instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        for (class_2350 direction : Iterate.directions) {
            class_2350.class_2351 axis = direction.method_10166();
            if (boxAxis == axis) continue;
            RotatingInstance instance = (RotatingInstance)instancer.createInstance();
            instance.setup(blockEntity, axis, this.getSpeed(direction)).setPosition((class_2382)this.getVisualPosition()).rotateToFace(class_2350.field_11035, direction).setChanged();
            this.keys.put(direction, instance);
        }
    }

    private float getSpeed(class_2350 direction) {
        float speed = ((GearboxBlockEntity)this.blockEntity).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null) {
            if (this.sourceFacing.method_10166() == direction.method_10166()) {
                speed *= this.sourceFacing == direction ? 1.0f : -1.0f;
            } else if (this.sourceFacing.method_10171() == direction.method_10171()) {
                speed *= -1.0f;
            }
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (((GearboxBlockEntity)this.blockEntity).hasSource()) {
            class_2338 source = ((GearboxBlockEntity)this.blockEntity).source.method_10059((class_2382)this.pos);
            this.sourceFacing = class_2350.method_10147((float)source.method_10263(), (float)source.method_10264(), (float)source.method_10260());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update(float pt) {
        this.updateSourceFacing();
        for (Map.Entry<class_2350, RotatingInstance> key : this.keys.entrySet()) {
            class_2350 direction = key.getKey();
            class_2350.class_2351 axis = direction.method_10166();
            key.getValue().setup((KineticBlockEntity)this.blockEntity, axis, this.getSpeed(direction)).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys.values().toArray(FlatLit[]::new));
    }

    protected void _delete() {
        this.keys.values().forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.keys.values().forEach(consumer);
    }
}

