/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_2211;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2391;
import net.minecraft.class_2392;
import net.minecraft.class_2393;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2511;
import net.minecraft.class_2520;
import net.minecraft.class_2523;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class SawBlockEntity
extends BlockBreakingKineticBlockEntity
implements SidedStorageBlockEntity {
    private static final Object cuttingRecipesKey = new Object();
    public static final Supplier<class_3956<?>> woodcuttingRecipeType = Suppliers.memoize(() -> (class_3956)class_7923.field_41188.method_10223(new class_2960("druidcraft", "woodcutting")));
    public ProcessingInventory inventory;
    private int recipeIndex;
    private FilteringBehaviour filtering;
    private class_1799 playEvent;

    public SawBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = class_1799.field_8037;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new SawFilterSlot()).forRecipes();
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
        this.registerAwardables(behaviours, AllAdvancements.SAW_PROCESSING);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10569("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.method_7960()) {
            return;
        }
        compound.method_10566("PlayEvent", NBTSerializer.serializeNBT((Object)this.playEvent));
        this.playEvent = class_1799.field_8037;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.recipeIndex = compound.method_10550("RecipeIndex");
        if (compound.method_10545("PlayEvent")) {
            this.playEvent = class_1799.method_7915((class_2487)compound.method_10562("PlayEvent"));
        }
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(0.125);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.method_7960()) {
            boolean isWood = false;
            class_1792 item = this.playEvent.method_7909();
            if (item instanceof class_1747) {
                class_2248 block = ((class_1747)item).method_7711();
                isWood = block.method_9573(block.method_9564()) == class_2498.field_11547;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = class_1799.field_8037;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.field_11863, (class_2382)this.field_11867, 3.0f, 1.0f, true);
            }
            return;
        }
    }

    @Override
    public void tick() {
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.method_5442() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        class_243 itemMovement = this.getItemMovementVec();
        class_2350 itemMovementFacing = class_2350.method_10142((double)itemMovement.field_1352, (double)itemMovement.field_1351, (double)itemMovement.field_1350);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 tryExportingToBeltFunnel;
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960() || (tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(stack, itemMovementFacing.method_10153(), false)) == null) continue;
            if (tryExportingToBeltFunnel.method_7947() != stack.method_7947()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.method_7960()) continue;
            return;
        }
        class_2338 nextPos = this.field_11867.method_10081((class_2382)class_2338.method_49638((class_2374)itemMovement));
        DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
                class_1799 remainder;
                class_1799 stack = this.inventory.getStackInSlot(slot);
                if (stack.method_7960() || class_1799.method_7973((class_1799)(remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)), (class_1799)stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
            return;
        }
        class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(itemMovement.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
        class_243 outMotion = itemMovement.method_1021(0.0625).method_1031(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
            entityIn.method_18799(outMotion);
            this.field_11863.method_8649((class_1297)entityIn);
        }
        this.inventory.clear();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.inventory);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return face == class_2350.field_11033 ? null : this.inventory;
    }

    protected void spawnEventParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        Object particleData = null;
        particleData = stack.method_7909() instanceof class_1747 ? new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564()) : new class_2392(class_2398.field_11218, stack);
        class_5819 r = this.field_11863.field_9229;
        class_243 v = VecHelper.getCenterOf((class_2382)this.field_11867).method_1031(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            class_243 m = VecHelper.offsetRandomly((class_243)new class_243(0.0, 0.25, 0.0), (class_5819)r, (float)0.125f);
            this.field_11863.method_8406((class_2394)particleData, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1351);
        }
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_2392 particleData = null;
        float speed = 1.0f;
        if (stack.method_7909() instanceof class_1747) {
            particleData = new class_2388(class_2398.field_11217, ((class_1747)stack.method_7909()).method_7711().method_9564());
        } else {
            particleData = new class_2392(class_2398.field_11218, stack);
            speed = 0.125f;
        }
        class_5819 r = this.field_11863.field_9229;
        class_243 vec = this.getItemMovementVec();
        class_243 pos = VecHelper.getCenterOf((class_2382)this.field_11867);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.field_11863.method_8406((class_2394)particleData, pos.method_10216() + -vec.field_1352 * (double)offset, pos.method_10214() + (double)0.45f, pos.method_10215() + -vec.field_1350 * (double)offset, -vec.field_1352 * (double)speed, (double)(r.method_43057() * speed), -vec.field_1350 * (double)speed);
    }

    public class_243 getItemMovementVec() {
        boolean alongX = (Boolean)this.method_11010().method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new class_243((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        class_1799 input = this.inventory.getStackInSlot(0);
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        if (PackageItem.isPackage(input)) {
            this.inventory.clear();
            ItemStackHandler results = PackageItem.getContents(input);
            for (int i = 0; i < results.getSlotCount(); ++i) {
                class_1799 stack = results.getStackInSlot(i);
                if (stack.method_7960()) continue;
                ItemHelper.addToList(stack, list);
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlotCount(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (class_1799)list.get(slot));
            }
            return;
        }
        List<class_1860<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        class_1860<?> recipe = recipes.get(this.recipeIndex);
        int rolls = input.method_7947();
        this.inventory.clear();
        for (int roll = 0; roll < rolls; ++roll) {
            List<Object> results = new LinkedList();
            if (recipe instanceof CuttingRecipe) {
                results = ((CuttingRecipe)recipe).rollResults();
            } else if (recipe instanceof class_3975 || recipe.method_17716() == woodcuttingRecipeType.get()) {
                results.add(recipe.method_8110(this.field_11863.method_30349()).method_7972());
            }
            for (class_1799 class_17992 : results) {
                ItemHelper.addToList(class_17992, list);
            }
            class_1799 remainder = input.getRecipeRemainder();
            if (remainder.method_7960()) continue;
            ItemHelper.addToList(remainder, list);
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlotCount(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (class_1799)list.get(slot));
        }
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private List<? extends class_1860<?>> getRecipes() {
        Optional<CuttingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(this.field_11863, this.inventory.getStackInSlot(0), AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(assemblyRecipe.get().method_8110(this.field_11863.method_30349()))) {
            return ImmutableList.of((Object)assemblyRecipe.get());
        }
        Predicate<class_1860<?>> types = RecipeConditions.isOfType(new class_3956[]{AllRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? class_3956.field_17641 : null});
        List<class_1860<?>> startedSearch = RecipeFinder.get(cuttingRecipesKey, this.field_11863, types);
        return startedSearch.stream().filter(RecipeConditions.outputMatchesFilter(this.filtering)).filter(RecipeConditions.firstIngredientMatches(this.inventory.getStackInSlot(0))).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation(r)).collect(Collectors.toList());
    }

    public void insertItem(class_1542 entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.method_5442()) {
            return;
        }
        if (!entity.method_5805()) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        this.inventory.clear();
        try (Transaction t = TransferUtil.getTransaction();){
            class_1799 contained = entity.method_6983();
            long inserted = this.inventory.insert(ItemVariant.of((class_1799)contained), contained.method_7947(), (TransactionContext)t);
            if ((long)contained.method_7947() == inserted) {
                entity.method_31472();
            } else {
                entity.method_6979(ItemHandlerHelper.copyStackWithSize((class_1799)contained, (int)((int)((long)contained.method_7947() - inserted))));
            }
            t.commit();
        }
    }

    public void start(class_1799 inserted) {
        class_1860<?> recipe;
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.method_5442()) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<class_1860<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof CuttingRecipe) {
            time = ((CuttingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.method_7947() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.method_11010().method_11654((class_2769)SawBlock.FACING) == class_2350.field_11036;
    }

    @Override
    protected boolean shouldRun() {
        return ((class_2350)this.method_11010().method_11654((class_2769)SawBlock.FACING)).method_10166().method_10179();
    }

    @Override
    protected class_2338 getBreakingPos() {
        return this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(class_2680 stateToBreak) {
        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(stateToBreak.method_26204(), this.breakingPos);
        if (dynamicTree.isPresent()) {
            dynamicTree.get().destroyBlocks(this.field_11863, null, this::dropItemFromCutTree);
            return;
        }
        super.onBlockBroken(stateToBreak);
        TreeCutter.findTree((class_1922)this.field_11863, this.breakingPos, stateToBreak).destroyBlocks(this.field_11863, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(class_2338 pos, class_1799 stack) {
        float distance = (float)Math.sqrt(pos.method_10262((class_2382)this.breakingPos));
        class_243 dropPos = VecHelper.getCenterOf((class_2382)pos);
        class_1542 entity = new class_1542(this.field_11863, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, stack);
        entity.method_18799(class_243.method_24954((class_2382)this.breakingPos.method_10059((class_2382)this.field_11867)).method_1021((double)(distance / 20.0f)));
        this.field_11863.method_8649((class_1297)entity);
    }

    @Override
    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        boolean sawable = SawBlockEntity.isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(class_2680 stateToBreak) {
        if (stateToBreak.method_26164(class_3481.field_15462)) {
            return false;
        }
        if (TreeCutter.isLog(stateToBreak) || stateToBreak.method_26164(class_3481.field_15503)) {
            return true;
        }
        if (TreeCutter.isRoot(stateToBreak)) {
            return true;
        }
        class_2248 block = stateToBreak.method_26204();
        if (block instanceof class_2211) {
            return true;
        }
        if (block instanceof class_2511) {
            return true;
        }
        if (block instanceof class_2266) {
            return true;
        }
        if (block instanceof class_2523) {
            return true;
        }
        if (block instanceof class_2391) {
            return true;
        }
        if (block instanceof class_2393) {
            return true;
        }
        if (block instanceof class_2283) {
            return true;
        }
        return TreeCutter.canDynamicTreeCutFrom(block);
    }
}

