/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ItemNameAttribute
implements ItemAttribute {
    private String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    private static String extractCustomName(class_1799 stack) {
        class_2487 compoundnbt = stack.method_7941("display");
        if (compoundnbt != null && compoundnbt.method_10573("Name", 8)) {
            try {
                class_5250 itextcomponent = class_2561.class_2562.method_10877((String)compoundnbt.method_10558("Name"));
                if (itextcomponent != null) {
                    return itextcomponent.getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return ItemNameAttribute.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_NAME;
    }

    @Override
    public void save(class_2487 nbt) {
        nbt.method_10582("name", this.itemName);
    }

    @Override
    public void load(class_2487 nbt) {
        this.itemName = nbt.method_10558("name");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemNameAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = ItemNameAttribute.extractCustomName(stack);
            if (!name.isEmpty()) {
                list.add(new ItemNameAttribute(name));
            }
            return list;
        }
    }
}

