/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortAutomationInventoryWrapper;
import com.simibubi.create.content.logistics.packagePort.PackagePortMenu;
import com.simibubi.create.content.logistics.packagePort.PackagePortTarget;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public abstract class PackagePortBlockEntity
extends SmartBlockEntity
implements class_3908,
SidedStorageBlockEntity {
    public boolean acceptsPackages = true;
    public String addressFilter = "";
    public PackagePortTarget target;
    public SmartInventory inventory = new SmartInventory(18, this, PackageItem::isPackage);
    protected AnimatedContainerBehaviour<PackagePortMenu> openTracker;
    protected final Storage<ItemVariant> exposedInventory = new PackagePortAutomationInventoryWrapper((Storage<ItemVariant>)this.inventory, this);

    public PackagePortBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean isBackedUp() {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            if (!this.inventory.getStackInSlot(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public void filterChanged() {
        if (this.target != null) {
            this.target.deregister(this, (class_1936)this.field_11863, this.field_11867);
            this.target.register(this, (class_1936)this.field_11863, this.field_11867);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.target != null) {
            this.target.register(this, (class_1936)this.field_11863, this.field_11867);
        }
    }

    public String getFilterString() {
        return this.acceptsPackages ? this.addressFilter : null;
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.target != null) {
            tag.method_10566("Target", (class_2520)this.target.write());
        }
        tag.method_10582("AddressFilter", this.addressFilter);
        tag.method_10556("AcceptsPackages", this.acceptsPackages);
        tag.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inventory.deserializeNBT(tag.method_10562("Inventory"));
        PackagePortTarget prevTarget = this.target;
        this.target = PackagePortTarget.read(tag.method_10562("Target"));
        this.addressFilter = tag.method_10558("AddressFilter");
        this.acceptsPackages = tag.method_10577("AcceptsPackages");
        if (clientPacket && prevTarget != this.target) {
            this.invalidateRenderBoundingBox();
        }
    }

    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        return this.exposedInventory;
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.deregister(this, (class_1936)this.field_11863, this.field_11867);
        }
        super.destroy();
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            this.drop(this.inventory.getStackInSlot(i));
        }
    }

    public void drop(class_1799 box) {
        if (box.method_7960()) {
            return;
        }
        class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)box);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<PackagePortMenu>(this, PackagePortMenu.class);
        behaviours.add(this.openTracker);
        this.openTracker.onOpenChanged(this::onOpenChange);
    }

    protected abstract void onOpenChange(boolean var1);

    public class_1269 use(class_1657 player) {
        if (player == null || player.method_18276()) {
            return class_1269.field_5811;
        }
        if (player instanceof FakePlayer) {
            return class_1269.field_5811;
        }
        class_1799 mainHandItem = player.method_6047();
        boolean clipboard = AllBlocks.CLIPBOARD.isIn(mainHandItem);
        if (this.field_11863.field_9236) {
            if (!clipboard) {
                this.onOpenedManually();
            }
            return class_1269.field_5812;
        }
        if (clipboard) {
            this.addAddressToClipboard(player, mainHandItem);
            return class_1269.field_5812;
        }
        NetworkHooks.openScreen((class_3222)((class_3222)player), (class_3908)this, (class_2338)this.field_11867);
        return class_1269.field_5812;
    }

    protected void onOpenedManually() {
    }

    private void addAddressToClipboard(class_1657 player, class_1799 mainHandItem) {
        if (this.addressFilter == null || this.addressFilter.isBlank()) {
            return;
        }
        List<List<ClipboardEntry>> list = ClipboardEntry.readAll(mainHandItem);
        for (List<ClipboardEntry> page : list) {
            for (ClipboardEntry entry : page) {
                String existing = entry.text.getString();
                if (!existing.equals("#" + this.addressFilter) && !existing.equals("# " + this.addressFilter)) continue;
                return;
            }
        }
        List<ClipboardEntry> page = null;
        for (List<ClipboardEntry> freePage : list) {
            if (freePage.size() > 11) continue;
            page = freePage;
            break;
        }
        if (page == null) {
            page = new ArrayList<ClipboardEntry>();
            list.add(page);
        }
        page.add(new ClipboardEntry(false, class_2561.method_43470((String)("#" + this.addressFilter))));
        player.method_7353((class_2561)CreateLang.translate("clipboard.address_added", this.addressFilter).component(), true);
        ClipboardEntry.saveAll(list, mainHandItem);
        mainHandItem.method_7969().method_10569("Type", ClipboardOverrides.ClipboardType.WRITTEN.ordinal());
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        return PackagePortMenu.create(pContainerId, pPlayerInventory, this);
    }

    public int getComparatorOutput() {
        return ItemHelper.calcRedstoneFromInventory((Storage<ItemVariant>)this.inventory);
    }
}

