/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.basin;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class BasinBlock
extends class_2248
implements IBE<BasinBlockEntity>,
IWrenchable {
    public static final class_2753 FACING = class_2741.field_12545;

    public BasinBlock(class_4970.class_2251 p_i48440_1_) {
        super(p_i48440_1_);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11033));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(new class_2769[]{FACING}));
    }

    public static boolean isBasin(class_4538 world, class_2338 pos) {
        return world.method_8321(pos) instanceof BasinBlockEntity;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos.method_10084());
        return !(blockEntity instanceof BasinOperatingBlockEntity);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (!context.method_8045().field_9236) {
            this.withBlockEntityDo((class_1922)context.method_8045(), context.method_8037(), bte -> bte.onWrenched(context.method_8038()));
        }
        return class_1269.field_5812;
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_1799 heldItem = player.method_5998(handIn);
        return this.onBlockEntityUse((class_1922)worldIn, pos, be -> {
            if (!heldItem.method_7960()) {
                Storage<FluidVariant> storage;
                class_2350 direction = hit.method_17780();
                if (FluidHelper.tryEmptyItemIntoBE(worldIn, player, handIn, heldItem, be, direction)) {
                    return class_1269.field_5812;
                }
                if (FluidHelper.tryFillItemFromBE(worldIn, player, handIn, heldItem, be, direction)) {
                    return class_1269.field_5812;
                }
                if (GenericItemEmptying.canItemBeEmptied(worldIn, heldItem) || GenericItemFilling.canItemBeFilled(worldIn, heldItem)) {
                    return class_1269.field_5812;
                }
                if (heldItem.method_7909().equals(class_1802.field_8535) && (storage = be.getFluidStorage(direction)) != null && !TransferUtil.extractAnyFluid(storage, (long)Long.MAX_VALUE).isEmpty()) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            Storage<ItemVariant> inv = be.itemCapability;
            if (inv == null) {
                return class_1269.field_5811;
            }
            List extracted = TransferUtil.extractAllAsStacks(inv);
            if (extracted.size() > 0) {
                extracted.forEach(s -> player.method_31548().method_7398(s));
                worldIn.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            }
            be.onEmptied();
            return class_1269.field_5812;
        });
    }

    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        if (!worldIn.method_8320(entityIn.method_24515()).method_27852((class_2248)this)) {
            return;
        }
        if (!(entityIn instanceof class_1542)) {
            return;
        }
        class_1542 itemEntity = (class_1542)entityIn;
        if (!entityIn.method_5805()) {
            return;
        }
        this.withBlockEntityDo(worldIn, entityIn.method_24515(), be -> {
            be.inputInventory.withMaxStackSize(64);
            class_1799 stack = itemEntity.method_6983().method_7972();
            try (Transaction t = TransferUtil.getTransaction();){
                long inserted = be.inputInventory.insert(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
                t.commit();
                if (inserted == (long)stack.method_7947()) {
                    itemEntity.method_31472();
                    return;
                }
                stack.method_7939((int)((long)stack.method_7947() - inserted));
                itemEntity.method_6979(stack);
            }
        });
    }

    public class_265 method_9584(class_2680 p_199600_1_, class_1922 p_199600_2_, class_2338 p_199600_3_) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 reader, class_2338 pos, class_3726 ctx) {
        if (ctx instanceof class_3727 && ((class_3727)ctx).method_32480() instanceof class_1542) {
            return AllShapes.BASIN_COLLISION_SHAPE;
        }
        return this.method_9530(state, reader, pos, ctx);
    }

    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        IBE.onRemove(state, worldIn, pos, newState);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos) {
        return this.getBlockEntityOptional((class_1922)worldIn, pos).map(BasinBlockEntity::getInputInventory).filter(basin -> !Transaction.isOpen()).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Override
    public Class<BasinBlockEntity> getBlockEntityClass() {
        return BasinBlockEntity.class;
    }

    @Override
    public class_2591<? extends BasinBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.BASIN.get();
    }

    public static boolean canOutputTo(class_1922 world, class_2338 basinPos, class_2350 direction) {
        DirectBeltInputBehaviour directBeltInputBehaviour;
        class_2338 neighbour = basinPos.method_10093(direction);
        class_2338 output = neighbour.method_10074();
        class_2680 blockState = world.method_8320(neighbour);
        if (FunnelBlock.isFunnel(blockState)) {
            if (FunnelBlock.getFunnelFacing(blockState) == direction) {
                return false;
            }
        } else {
            if (!blockState.method_26220(world, neighbour).method_1110()) {
                return false;
            }
            class_2586 blockEntity = world.method_8321(output);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return belt.getSpeed() == 0.0f || belt.getMovementFacing() != direction.method_10153();
            }
        }
        if ((directBeltInputBehaviour = BlockEntityBehaviour.get(world, output, DirectBeltInputBehaviour.TYPE)) != null) {
            return directBeltInputBehaviour.canInsertFromSide(direction);
        }
        return false;
    }

    public boolean method_9516(class_2680 state, class_1922 reader, class_2338 pos, class_10 type) {
        return false;
    }
}

