/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.table.SchematicTableBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.CreatePaths;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CSchematics;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class ServerSchematicLoader {
    private final Map<String, SchematicUploadEntry> activeUploads;
    private final ObjectArrayList<String> deadEntries = ObjectArrayList.of();

    public ServerSchematicLoader() {
        this.activeUploads = new HashMap<String, SchematicUploadEntry>();
    }

    public void tick() {
        int timeout = (Integer)this.getConfig().schematicIdleTimeout.get();
        for (String upload : this.activeUploads.keySet()) {
            SchematicUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= timeout) continue;
            Create.LOGGER.warn("Schematic Upload timed out: " + upload);
            this.deadEntries.add((Object)upload);
        }
        for (String toRemove : this.deadEntries) {
            this.cancelUpload(toRemove);
        }
        this.deadEntries.clear();
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(class_3222 player, String schematic, long size, class_2338 pos) {
        String playerName = player.method_7334().getName();
        Path baseDir = CreatePaths.UPLOADED_SCHEMATICS_DIR;
        Path playerPath = baseDir.resolve(playerName).normalize();
        Path uploadPath = playerPath.resolve(schematic).normalize();
        String playerSchematicId = playerName + "/" + schematic;
        if (!playerPath.startsWith(baseDir) || !uploadPath.startsWith(playerPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with path traversal: {}", (Object)playerSchematicId);
            return;
        }
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: {}", (Object)playerSchematicId);
            return;
        }
        if (!this.validateSchematicSizeOnServer(player, size)) {
            return;
        }
        if (this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        try {
            long count;
            SchematicTableBlockEntity table = this.getTable(player.method_5770(), pos);
            if (table == null) {
                return;
            }
            Files.deleteIfExists(uploadPath);
            try (Stream<Path> list = Files.list(playerPath);){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(playerPath);
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            OutputStream writer = Files.newOutputStream(uploadPath, new OpenOption[0]);
            this.activeUploads.put(playerSchematicId, new SchematicUploadEntry(writer, size, player.method_37908(), pos));
            table.startUpload(schematic);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when starting Upload: {}", (Object)playerSchematicId, (Object)e);
        }
    }

    protected boolean validateSchematicSizeOnServer(class_3222 player, long size) {
        long maxFileSize = ((Integer)this.getConfig().maxTotalSchematicSize.get()).intValue();
        if (size > maxFileSize * 1000L) {
            player.method_43496((class_2561)CreateLang.translateDirect("schematics.uploadTooLarge", new Object[0]).method_10852((class_2561)class_2561.method_43470((String)(" (" + size / 1000L + " KB)."))));
            player.method_43496((class_2561)CreateLang.translateDirect("schematics.maxAllowedSize", new Object[0]).method_10852((class_2561)class_2561.method_43470((String)(" " + maxFileSize + " KB"))));
            return false;
        }
        return true;
    }

    public CSchematics getConfig() {
        return AllConfigs.server().schematics;
    }

    public void handleWriteRequest(class_3222 player, String schematic, byte[] data) {
        String playerSchematicId = player.method_7334().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            SchematicUploadEntry entry = this.activeUploads.get(playerSchematicId);
            entry.bytesUploaded += (long)data.length;
            if (data.length > (Integer)this.getConfig().maxSchematicPacketSize.get()) {
                Create.LOGGER.warn("Oversized Upload Packet received: {}", (Object)playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                Create.LOGGER.warn("Received more data than Expected: {}", (Object)playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                SchematicTableBlockEntity table = this.getTable(entry.world, entry.tablePos);
                if (table == null) {
                    return;
                }
                table.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                table.sendUpdate = true;
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when uploading Schematic: {}", (Object)playerSchematicId, (Object)e);
                this.cancelUpload(playerSchematicId);
            }
        }
    }

    protected void cancelUpload(String playerSchematicId) {
        if (!this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        SchematicUploadEntry entry = this.activeUploads.remove(playerSchematicId);
        try {
            entry.stream.close();
            Files.deleteIfExists(CreatePaths.UPLOADED_SCHEMATICS_DIR.resolve(playerSchematicId));
            Create.LOGGER.warn("Cancelled Schematic Upload: {}", (Object)playerSchematicId);
        }
        catch (IOException e) {
            Create.LOGGER.error("Exception Thrown when cancelling Upload: {}", (Object)playerSchematicId, (Object)e);
        }
        class_2338 pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        SchematicTableBlockEntity table = this.getTable(entry.world, pos);
        if (table != null) {
            table.finishUpload();
        }
    }

    public SchematicTableBlockEntity getTable(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof SchematicTableBlockEntity)) {
            return null;
        }
        SchematicTableBlockEntity table = (SchematicTableBlockEntity)be;
        return table;
    }

    public void handleFinishedUpload(class_3222 player, String schematic) {
        String playerSchematicId = player.method_7334().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                class_1937 world = removed.world;
                class_2338 pos = removed.tablePos;
                Create.LOGGER.info("New Schematic Uploaded: " + playerSchematicId);
                if (pos == null) {
                    return;
                }
                class_2680 blockState = world.method_8320(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.method_26204()) {
                    return;
                }
                SchematicTableBlockEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                table.inventory.setStackInSlot(1, SchematicItem.create(world, schematic, player.method_7334().getName()));
            }
            catch (IOException e) {
                Create.LOGGER.error("Exception Thrown when finishing Upload: {}", (Object)playerSchematicId, (Object)e);
            }
        }
    }

    public void handleInstantSchematic(class_3222 player, String schematic, class_1937 world, class_2338 pos, class_2338 bounds) {
        String playerName = player.method_7334().getName();
        Path baseDir = CreatePaths.UPLOADED_SCHEMATICS_DIR;
        Path playerPath = baseDir.resolve(playerName).normalize();
        Path uploadPath = playerPath.resolve(schematic).normalize();
        String playerSchematicId = playerName + "/" + schematic;
        if (!playerPath.startsWith(baseDir) || !uploadPath.startsWith(playerPath)) {
            Create.LOGGER.warn("Attempted Schematic Upload with path traversal: {}", (Object)playerSchematicId);
            return;
        }
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.LOGGER.warn("Attempted Schematic Upload with non-supported Format: {}", (Object)playerSchematicId);
            return;
        }
        if (!AllItems.SCHEMATIC_AND_QUILL.isIn(player.method_6047())) {
            return;
        }
        if (!this.tryDeleteOldestSchematic(playerPath)) {
            return;
        }
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(playerPath, schematic, true, world, pos, pos.method_10081((class_2382)bounds).method_10069(-1, -1, -1));
        if (result != null) {
            player.method_6122(class_1268.field_5808, SchematicItem.create(world, schematic, playerName));
        } else {
            CreateLang.translate("schematicAndQuill.instant_failed", new Object[0]).style(class_124.field_1061).sendStatus((class_1657)player);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryDeleteOldestSchematic(Path dir) {
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> files = stream.toList();
            if (files.size() < (Integer)this.getConfig().maxSchematics.get()) {
                boolean bl2 = true;
                return bl2;
            }
            Optional<Path> oldest = files.stream().min(Comparator.comparingLong(this::getLastModifiedTime));
            Files.delete(oldest.orElseThrow());
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalStateException e) {
            Create.LOGGER.error("Error deleting oldest schematic", (Throwable)e);
            return false;
        }
    }

    private long getLastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            Create.LOGGER.error("Error getting modification time of file {}", (Object)file.getFileName(), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public static class SchematicUploadEntry {
        public class_1937 world;
        public class_2338 tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public SchematicUploadEntry(OutputStream stream, long totalBytes, class_1937 world, class_2338 tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

