/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableObject;

public class TimeOfDayCondition
extends ScheduleWaitCondition {
    public TimeOfDayCondition() {
        this.data.method_10569("Hour", 8);
        this.data.method_10569("Rotation", 5);
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        int targetTicks;
        int maxTickDiff = 40;
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        int dayTime = (int)(level.method_8532() % (long)this.getRotation());
        int diff = dayTime - (targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation()));
        return diff >= 0 && maxTickDiff >= diff;
    }

    public int getRotation() {
        int index = this.intData("Rotation");
        return switch (index) {
            case 9 -> 250;
            case 8 -> 500;
            case 7 -> 750;
            case 6 -> 1000;
            case 5 -> 2000;
            case 4 -> 3000;
            case 3 -> 4000;
            case 2 -> 6000;
            case 1 -> 12000;
            default -> 24000;
        };
    }

    @Override
    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)new class_1799((class_1935)class_1802.field_8615), (Object)this.getDigitalDisplay(this.intData("Hour"), this.intData("Minute"), false));
    }

    public class_5250 getDigitalDisplay(int hour, int minute, boolean doubleDigitHrs) {
        int hour12raw = hour % 12 == 0 ? 12 : hour % 12;
        Object hr12 = doubleDigitHrs ? this.twoDigits(hour12raw) : "" + hour12raw;
        Object hr24 = doubleDigitHrs ? this.twoDigits(hour) : "" + hour;
        return CreateLang.translateDirect("schedule.condition.time_of_day.digital_format", hr12, hr24, this.twoDigits(minute), hour > 11 ? CreateLang.translateDirect("generic.daytime.pm", new Object[0]) : CreateLang.translateDirect("generic.daytime.am", new Object[0]));
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.time_of_day.scheduled", new Object[0]), (Object)this.getDigitalDisplay(this.intData("Hour"), this.intData("Minute"), false).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1063)).method_10852((class_2561)CreateLang.translatedOptions("schedule.condition.time_of_day.rotation", "every_24", "every_12", "every_6", "every_4", "every_3", "every_2", "every_1", "every_0_45", "every_0_30", "every_0_15").get(this.intData("Rotation")).method_27661().method_27692(class_124.field_1080)));
    }

    public String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("time_of_day");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderSpecialIcon(class_332 graphics, int x, int y) {
        int displayHr = (this.intData("Hour") + 12) % 24;
        float progress = ((float)displayHr * 60.0f + (float)this.intData("Minute")) / 1440.0f;
        class_2960 location = new class_2960("textures/item/clock_" + this.twoDigits(class_3532.method_15340((int)((int)(progress * 64.0f)), (int)0, (int)63)) + ".png");
        graphics.method_25291(location, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        MutableObject minuteInput = new MutableObject();
        MutableObject hourInput = new MutableObject();
        MutableObject timeLabel = new MutableObject();
        builder.addScrollInput(0, 16, (i, l) -> {
            i.withRange(0, 24);
            timeLabel.setValue((Object)l);
            hourInput.setValue((Object)i);
        }, "Hour");
        builder.addScrollInput(18, 16, (i, l) -> {
            i.withRange(0, 60);
            minuteInput.setValue((Object)i);
            l.field_22764 = false;
        }, "Minute");
        builder.addSelectionScrollInput(52, 62, (i, l) -> i.forOptions(CreateLang.translatedOptions("schedule.condition.time_of_day.rotation", "every_24", "every_12", "every_6", "every_4", "every_3", "every_2", "every_1", "every_0_45", "every_0_30", "every_0_15")).titled(CreateLang.translateDirect("schedule.condition.time_of_day.rotation", new Object[0])), "Rotation");
        ((ScrollInput)((Object)hourInput.getValue())).titled(CreateLang.translateDirect("generic.daytime.hour", new Object[0])).calling(t -> {
            this.data.method_10569("Hour", t.intValue());
            ((Label)((Object)((Object)timeLabel.getValue()))).text = this.getDigitalDisplay((int)t, ((ScrollInput)((Object)((Object)minuteInput.getValue()))).getState(), true);
        }).writingTo(null).withShiftStep(6);
        ((ScrollInput)((Object)minuteInput.getValue())).titled(CreateLang.translateDirect("generic.daytime.minute", new Object[0])).calling(t -> {
            this.data.method_10569("Minute", t.intValue());
            ((Label)((Object)((Object)timeLabel.getValue()))).text = this.getDigitalDisplay(((ScrollInput)((Object)((Object)hourInput.getValue()))).getState(), (int)t, true);
        }).writingTo(null).withShiftStep(15);
        ((ScrollInput)((Object)hourInput.getValue())).lockedTooltipX = -15;
        ((ScrollInput)((Object)minuteInput.getValue())).lockedTooltipX = -15;
        ((ScrollInput)((Object)hourInput.getValue())).lockedTooltipY = 35;
        ((ScrollInput)((Object)minuteInput.getValue())).lockedTooltipY = 35;
        ((ScrollInput)((Object)hourInput.getValue())).setState(this.intData("Hour"));
        ((ScrollInput)((Object)minuteInput.getValue())).setState(this.intData("Minute")).onChanged();
        builder.customArea(0, 52);
        builder.customArea(52, 69);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        int dayTime = (int)(level.method_8532() % (long)this.getRotation());
        int targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation());
        int diff = targetTicks - dayTime;
        if (diff < 0) {
            diff += this.getRotation();
        }
        int departureTime = (int)(level.method_8532() + (long)diff) % 24000;
        int departingHour = (departureTime / 1000 + 6) % 24;
        int departingMinute = departureTime % 1000 * 60 / 1000;
        return CreateLang.translateDirect("schedule.condition.time_of_day.status", new Object[0]).method_10852((class_2561)this.getDigitalDisplay(departingHour, departingMinute, false));
    }
}

