/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.CreateClient;
import com.simibubi.create.compat.computercraft.ComputerScreen;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationRenderer;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class AbstractStationScreen
extends AbstractSimiScreen {
    protected AllGuiTextures background;
    protected StationBlockEntity blockEntity;
    protected GlobalStation station;
    protected WeakReference<Train> displayedTrain;
    private IconButton confirmButton;

    public AbstractStationScreen(StationBlockEntity be, GlobalStation station) {
        super((class_2561)be.method_11010().method_26204().method_9518());
        this.blockEntity = be;
        this.station = station;
        this.displayedTrain = new WeakReference<Object>(null);
    }

    protected void method_25426() {
        if (this.blockEntity.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> class_2561.method_43470((String)this.station.name), this::renderAdditional, (class_437)this, this.blockEntity.computerBehaviour::hasAttachedComputer));
        }
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.method_25426();
        this.method_37067();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((AbstractStationScreen)this).method_25419());
        this.method_37063((class_364)this.confirmButton);
    }

    public int getTrainIconWidth(Train train) {
        TrainIconType icon = train.icon;
        List<Carriage> carriages = train.carriages;
        int w = icon.getIconWidth(-1);
        if (carriages.size() == 1) {
            return w;
        }
        for (int i = 1; i < carriages.size(); ++i) {
            if (i == carriages.size() - 1 && train.doubleEnded) {
                w += icon.getIconWidth(-2) + 1;
                break;
            }
            Carriage carriage = carriages.get(i);
            w += icon.getIconWidth(carriage.bogeySpacing) + 1;
        }
        return w;
    }

    public void method_25393() {
        super.method_25393();
        if (this.blockEntity.computerBehaviour.hasAttachedComputer()) {
            this.field_22787.method_1507((class_437)new ComputerScreen(this.field_22785, () -> class_2561.method_43470((String)this.station.name), this::renderAdditional, (class_437)this, this.blockEntity.computerBehaviour::hasAttachedComputer));
        }
    }

    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.renderAdditional(graphics, mouseX, mouseY, partialTicks, x, y, this.background);
    }

    private void renderAdditional(class_332 graphics, int mouseX, int mouseY, float partialTicks, int guiLeft, int guiTop, AllGuiTextures background) {
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        PoseTransformStack msr = TransformStack.of((class_4587)ms);
        ((PoseTransformStack)((PoseTransformStack)msr.pushPose().translate((float)(guiLeft + background.getWidth() + 4), (float)(guiTop + background.getHeight() + 4), 100.0f).scale(40.0f)).rotateXDegrees(-22.0f)).rotateYDegrees(63.0f);
        GuiGameElement.of((class_2680)((class_2680)this.blockEntity.method_11010().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)))).render(graphics);
        if (this.blockEntity.resolveFlagAngle()) {
            msr.translate(0.0625f, -1.1875f, -0.75f);
            StationRenderer.transformFlag(msr, this.blockEntity, partialTicks, 180, false);
            GuiGameElement.of((PartialModel)this.getFlag(partialTicks)).render(graphics);
        }
        ms.method_22909();
    }

    protected abstract PartialModel getFlag(float var1);

    protected Train getImminent() {
        return this.blockEntity.imminentTrain == null ? null : CreateClient.RAILWAYS.trains.get(this.blockEntity.imminentTrain);
    }

    protected boolean trainPresent() {
        return this.blockEntity.trainPresent;
    }
}

