/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.Create;
import com.simibubi.create.compat.computercraft.events.PackageEvent;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.StationBlock;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class GlobalStation
extends SingleBlockEntityEdgePoint {
    public String name = "Track Station";
    public WeakReference<Train> nearestTrain = new WeakReference<Object>(null);
    public boolean assembling;
    public Map<class_2338, GlobalPackagePort> connectedPorts = new HashMap<class_2338, GlobalPackagePort>();

    @Override
    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        class_2680 state = blockEntity.method_11010();
        this.assembling = state != null && state.method_28498((class_2769)StationBlock.ASSEMBLING) && (Boolean)state.method_11654((class_2769)StationBlock.ASSEMBLING) != false;
    }

    @Override
    public void read(class_2487 nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.name = nbt.method_10558("Name");
        this.assembling = nbt.method_10577("Assembling");
        this.nearestTrain = new WeakReference<Object>(null);
        this.connectedPorts.clear();
        class_2499 portList = nbt.method_10554("Ports", 10);
        NBTHelper.iterateCompoundList((class_2499)portList, c -> {
            GlobalPackagePort port = new GlobalPackagePort();
            port.address = c.method_10558("Address");
            port.offlineBuffer.deserializeNBT(c.method_10562("OfflineBuffer"));
            port.primed = c.method_10577("Primed");
            this.connectedPorts.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), port);
        });
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.name = buffer.method_19772();
        this.assembling = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.method_10811();
        }
    }

    @Override
    public void write(class_2487 nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.method_10582("Name", this.name);
        nbt.method_10556("Assembling", this.assembling);
        nbt.method_10566("Ports", (class_2520)NBTHelper.writeCompoundList(this.connectedPorts.entrySet(), e -> {
            class_2487 c = new class_2487();
            c.method_10582("Address", ((GlobalPackagePort)e.getValue()).address);
            c.method_10566("OfflineBuffer", (class_2520)((GlobalPackagePort)e.getValue()).offlineBuffer.serializeNBT());
            c.method_10556("Primed", ((GlobalPackagePort)e.getValue()).primed);
            c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_2338)e.getKey())));
            return c;
        }));
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.method_10814(this.name);
        buffer.writeBoolean(this.assembling);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.method_10807(this.blockEntityPos);
        }
    }

    public boolean canApproachFrom(TrackNode side) {
        return this.isPrimary(side) && !this.assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !this.assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination) {
            this.nearestTrain = new WeakReference<Train>(train);
        }
    }

    public void cancelReservation(Train train) {
        if (this.nearestTrain.get() == train) {
            this.nearestTrain = new WeakReference<Object>(null);
        }
    }

    public void trainDeparted(Train train) {
        this.cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = this.getNearestTrain();
        if (nearestTrain == null) {
            return nearestTrain;
        }
        if (nearestTrain.getCurrentStation() == this) {
            return nearestTrain;
        }
        if (!nearestTrain.navigation.isActive()) {
            return null;
        }
        if (nearestTrain.navigation.distanceToDestination > 30.0) {
            return null;
        }
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return (Train)this.nearestTrain.get();
    }

    public void runMailTransfer() {
        Train train = this.getPresentTrain();
        if (train == null || this.connectedPorts.isEmpty()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        class_3218 level = server.method_3847(this.getBlockEntityDimension());
        for (Carriage carriage : train.carriages) {
            CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null) continue;
            for (Map.Entry<class_2338, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                class_2586 class_25862;
                GlobalPackagePort port = entry.getValue();
                class_2338 pos = entry.getKey();
                PostboxBlockEntity box = null;
                Object postboxInventory = port.offlineBuffer;
                if (level != null && level.method_8477(pos) && (class_25862 = level.method_8321(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)class_25862;
                    postboxInventory = ppbe.inventory;
                    box = ppbe;
                }
                for (int slot = 0; slot < postboxInventory.getSlotCount(); ++slot) {
                    class_1799 stack = postboxInventory.getStackInSlot(slot);
                    if (!PackageItem.isPackage(stack) || PackageItem.matchAddress(stack, port.address)) continue;
                    long inserted = TransferUtil.insertItem(carriageInventory, (class_1799)stack);
                    if (box != null) {
                        box.computerBehaviour.prepareComputerEvent(new PackageEvent(stack, "package_sent"));
                    }
                    if (inserted == 0L) continue;
                    postboxInventory.setStackInSlot(slot, class_1799.field_8037);
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                }
            }
            Transaction t = Transaction.openOuter();
            try {
                block8: for (StorageView view : carriageInventory.nonEmptyViews()) {
                    ItemVariant resource = (ItemVariant)view.getResource();
                    if (!PackageItem.isPackage(resource)) continue;
                    for (Map.Entry<class_2338, GlobalPackagePort> entry : this.connectedPorts.entrySet()) {
                        class_2586 class_25863;
                        GlobalPackagePort port = entry.getValue();
                        class_2338 pos = entry.getKey();
                        PostboxBlockEntity box = null;
                        if (!PackageItem.matchAddress(resource, port.address)) continue;
                        Object postboxInventory = port.offlineBuffer;
                        if (level != null && level.method_8477(pos) && (class_25863 = level.method_8321(pos)) instanceof PostboxBlockEntity) {
                            PostboxBlockEntity ppbe = (PostboxBlockEntity)class_25863;
                            postboxInventory = ppbe.inventory;
                            box = ppbe;
                        }
                        long inserted = postboxInventory.insert(resource, view.getAmount(), (TransactionContext)t);
                        if (box != null) {
                            class_1799 stack = resource.toStack();
                            box.computerBehaviour.prepareComputerEvent(new PackageEvent(stack, "package_received"));
                        }
                        if (inserted == 0L) continue;
                        view.extract((Object)resource, inserted, (TransactionContext)t);
                        if (box == null) {
                            port.primed = true;
                        } else {
                            box.spawnParticles();
                        }
                        Create.RAILWAYS.markTracksDirty();
                        continue block8;
                    }
                }
                t.commit();
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }
}

