/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.debugInfo;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.infrastructure.debugInfo.DebugInformation;
import com.simibubi.create.infrastructure.debugInfo.element.DebugInfoSection;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class ServerDebugInfoPacket
extends SimplePacketBase {
    private final List<DebugInfoSection> serverInfo;
    private final class_1657 player;

    public ServerDebugInfoPacket(class_1657 player) {
        this.serverInfo = DebugInformation.getServerInfo();
        this.player = player;
    }

    public ServerDebugInfoPacket(class_2540 buffer) {
        this.serverInfo = buffer.method_34066(DebugInfoSection::readDirect);
        this.player = null;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_34062(this.serverInfo, (buf, section) -> section.write(this.player, (class_2540)buf));
    }

    @Override
    public boolean handle(SimplePacketBase.Context context) {
        context.enqueueWork(() -> EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::handleOnClient));
        return true;
    }

    private void printInfo(String side, class_1657 player, List<DebugInfoSection> sections, StringBuilder output) {
        output.append("<details>");
        output.append('\n');
        output.append("<summary>").append(side).append(" Info").append("</summary>");
        output.append('\n').append('\n');
        output.append("```");
        output.append('\n');
        for (int i = 0; i < sections.size(); ++i) {
            if (i != 0) {
                output.append('\n');
            }
            sections.get(i).print(player, line -> output.append((String)line).append('\n'));
        }
        output.append("```");
        output.append('\n').append('\n');
        output.append("</details>");
        output.append('\n');
    }

    @Environment(value=EnvType.CLIENT)
    private void handleOnClient() {
        class_1657 player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        StringBuilder output = new StringBuilder();
        List<DebugInfoSection> clientInfo = DebugInformation.getClientInfo();
        this.printInfo("Client", player, clientInfo, output);
        output.append("\n\n");
        this.printInfo("Server", player, this.serverInfo, output);
        String text = output.toString();
        class_310.method_1551().field_1774.method_1455(text);
        Create.lang().translate("command.debuginfo.saved_to_clipboard", new Object[0]).color(((Integer)DyeHelper.getDyeColors(class_1767.field_7961).getFirst()).intValue()).sendChat(player);
    }
}

