/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotElement;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2769;

public class RollerScenes {
    public static void clearAndPave(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        int i2;
        int i3;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_roller_pave", "Clearing and Paving with the Roller");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.75f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 stationPos = util.grid().at(7, 1, 1);
        Selection gantryPole = util.select().fromTo(9, 5, 4, 1, 5, 4);
        Selection cogs = util.select().fromTo(9, 0, 4, 9, 4, 4);
        Selection gantryCar = util.select().fromTo(7, 2, 8, 7, 4, 8);
        class_2338 bogeyPos = util.grid().at(7, 2, 4);
        Selection someRubble = util.select().fromTo(2, 1, 3, 3, 2, 5).substract(util.select().fromTo(3, 1, 4, 2, 1, 4));
        Selection chest = util.select().fromTo(7, 2, 5, 8, 3, 5);
        Selection rollers = util.select().fromTo(6, 2, 3, 6, 2, 5);
        Selection train = util.select().fromTo(8, 3, 4, 7, 2, 4);
        class_2338 controlsPos = util.grid().at(7, 3, 4);
        for (int i4 = 8; i4 >= 0; --i4) {
            scene.world().showSection(util.select().position(i4, 1, 4), class_2350.field_11033);
            scene.idle(1);
        }
        scene.special().movePointOfInterest(util.grid().at(0, 3, 4));
        scene.idle(5);
        scene.world().showSection(util.select().position(stationPos), class_2350.field_11033);
        scene.idle(5);
        ElementLink<ParrotElement> birbLink = scene.special().createBirb(util.vector().centerOf(8, 3, 4), ParrotPose.FacePointOfInterestPose::new);
        ElementLink trainLink = scene.world().showIndependentSection(train, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSectionAndMerge(rollers, class_2350.field_11034, trainLink);
        scene.idle(15);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, true);
        scene.overlay().showText(60).pointAt(util.vector().topOf(util.grid().at(6, 2, 4))).attachKeyFrame().text("Mechanical rollers help to clean up terrain around tracks or paths").placeNearTarget();
        scene.idle(70);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, false);
        scene.world().showSection(someRubble, class_2350.field_11033);
        scene.world().toggleControls(controlsPos);
        scene.world().moveSection(trainLink, util.vector().of(-1.5, 0.0, 0.0), 30);
        scene.special().moveParrot(birbLink, util.vector().of(-1.5, 0.0, 0.0), 30);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 1.5f, 30);
        scene.idle(30);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.overlay().showControls(util.vector().topOf(util.grid().at(2, 2, 4)), Pointing.DOWN, 70).showing((ScreenElement)AllIcons.I_ROLLER_PAVE);
        scene.overlay().showText(80).pointAt(util.vector().topOf(util.grid().at(2, 2, 4))).attachKeyFrame().text("In its default mode, without a material set, it will simply clear blocks like a Drill").placeNearTarget();
        for (i3 = 0; i3 < 10; ++i3) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 1, 5));
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 1, 3));
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 2, 5));
        }
        scene.world().moveSection(trainLink, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.special().moveParrot(birbLink, util.vector().of(-1.0, 0.0, 0.0), 20);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 1.0f, 20);
        scene.idle(20);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        for (i3 = 0; i3 < 10; ++i3) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(util.grid().at(2, 2, 4));
            scene.world().incrementBlockBreakingProgress(util.grid().at(2, 1, 3));
        }
        scene.world().moveSection(trainLink, util.vector().of(-2.0, 0.0, 0.0), 40);
        scene.special().moveParrot(birbLink, util.vector().of(-2.0, 0.0, 0.0), 40);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 2.0f, 40);
        scene.idle(40);
        for (i3 = 0; i3 < 3; ++i3) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i3), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.special().hideElement(birbLink, class_2350.field_11036);
        scene.world().hideIndependentSection(trainLink, class_2350.field_11036);
        scene.idle(15);
        birbLink = scene.special().createBirb(util.vector().centerOf(8, 3, 4), ParrotPose.FacePointOfInterestPose::new);
        trainLink = scene.world().showIndependentSection(train, class_2350.field_11033);
        scene.world().toggleControls(controlsPos);
        scene.idle(5);
        scene.world().showSectionAndMerge(rollers, class_2350.field_11034, trainLink);
        scene.idle(15);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, true);
        scene.world().hideSection(someRubble, class_2350.field_11033);
        class_243 filterSlot = util.vector().of(6.6875, 3.0, 3.3125);
        scene.overlay().showFilterSlotInput(filterSlot, class_2350.field_11036, 60);
        scene.overlay().showText(60).pointAt(filterSlot.method_1031(-0.125, 0.0, 0.0)).attachKeyFrame().text("While disassembled, a suitable paving material can be specified").placeNearTarget();
        scene.idle(50);
        class_2248 paveMaterial = class_2246.field_27165;
        class_1799 paveItem = new class_1799((class_1935)paveMaterial);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 40).withItem(paveItem);
        scene.idle(7);
        scene.world().setFilterData(rollers, RollerBlockEntity.class, paveItem);
        scene.idle(20);
        scene.world().showSectionAndMerge(chest, class_2350.field_11033, trainLink);
        scene.idle(15);
        scene.overlay().showText(70).pointAt(util.vector().topOf(util.grid().at(7, 3, 5))).text("Materials can be supplied via chests or barrels attached to the structure").placeNearTarget();
        scene.idle(60);
        scene.world().restoreBlocks(someRubble);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, false);
        scene.world().showSection(someRubble, class_2350.field_11033);
        scene.world().toggleControls(controlsPos);
        scene.world().showSection(someRubble, class_2350.field_11033);
        scene.world().moveSection(trainLink, util.vector().of(-1.5, 0.0, 0.0), 30);
        scene.special().moveParrot(birbLink, util.vector().of(-1.5, 0.0, 0.0), 30);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 1.5f, 30);
        scene.world().replaceBlocks(util.select().fromTo(5, 0, 3, 5, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(20);
        scene.world().replaceBlocks(util.select().fromTo(4, 0, 3, 4, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(10);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.overlay().showText(80).pointAt(util.vector().topOf(util.grid().at(5, 0, 3))).attachKeyFrame().text("In addition to breaking blocks, it will now replace the layer beneath them").placeNearTarget();
        for (i2 = 0; i2 < 10; ++i2) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 1, 5));
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 1, 3));
            scene.world().incrementBlockBreakingProgress(util.grid().at(3, 2, 5));
        }
        scene.world().moveSection(trainLink, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.special().moveParrot(birbLink, util.vector().of(-1.0, 0.0, 0.0), 20);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 1.0f, 20);
        scene.idle(10);
        scene.world().replaceBlocks(util.select().fromTo(3, 0, 3, 3, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(10);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        for (i2 = 0; i2 < 10; ++i2) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(util.grid().at(2, 2, 4));
            scene.world().incrementBlockBreakingProgress(util.grid().at(2, 1, 3));
        }
        scene.world().moveSection(trainLink, util.vector().of(-3.0, 0.0, 0.0), 60);
        scene.special().moveParrot(birbLink, util.vector().of(-3.0, 0.0, 0.0), 60);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.world().animateBogey(bogeyPos, 3.0f, 60);
        scene.idle(10);
        scene.world().replaceBlocks(util.select().fromTo(2, 0, 3, 2, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(20);
        scene.world().replaceBlocks(util.select().fromTo(1, 0, 3, 1, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(20);
        scene.world().replaceBlocks(util.select().fromTo(0, 0, 3, 0, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(10);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.special().hideElement(birbLink, class_2350.field_11036);
        scene.world().hideIndependentSection(trainLink, class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(util.select().fromTo(8, 1, 4, 0, 1, 4), class_2350.field_11035);
        scene.world().hideSection(util.select().position(stationPos), class_2350.field_11036);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().fromTo(5, 0, 3, 0, 0, 5), 90).pointAt(util.vector().topOf(util.grid().at(3, 0, 4))).attachKeyFrame().colored(PonderPalette.RED).text("Note that any block destroyed by a roller has a chance not to yield drops").placeNearTarget();
        scene.idle(100);
        scene.world().showSection(gantryPole, class_2350.field_11033);
        scene.world().showSection(cogs, class_2350.field_11039);
        scene.idle(10);
        ElementLink gantryLink = scene.world().showIndependentSection(gantryCar, class_2350.field_11036);
        scene.world().moveSection(gantryLink, util.vector().of(0.0, 0.0, -4.0), 0);
        scene.idle(10);
        ElementLink gantryLink2 = scene.world().showIndependentSection(rollers, class_2350.field_11034);
        scene.idle(5);
        ElementLink gantryLink3 = scene.world().showIndependentSection(chest, class_2350.field_11035);
        scene.world().moveSection(gantryLink3, util.vector().of(0.0, 0.0, -2.0), 0);
        scene.idle(15);
        paveMaterial = class_2246.field_10219;
        paveItem = new class_1799((class_1935)paveMaterial);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 40).withItem(paveItem);
        scene.idle(7);
        scene.world().setFilterData(rollers, RollerBlockEntity.class, paveItem);
        scene.idle(20);
        scene.overlay().showText(110).independent().attachKeyFrame().text("Rollers are especially useful on Trains, but can also be used on most other types of moving contraptions");
        scene.idle(20);
        scene.world().moveSection(gantryLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().moveSection(gantryLink2, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().moveSection(gantryLink3, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().setKineticSpeed(gantryPole, 48.0f);
        for (i = 0; i < 5; ++i) {
            scene.world().setKineticSpeed(util.select().position(9, i, 4), i % 2 == 0 ? -48.0f : 48.0f);
        }
        for (i = 0; i < 3; ++i) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        for (i = 0; i < 5; ++i) {
            scene.world().replaceBlocks(util.select().fromTo(5 - i, 0, 3, 5 - i, 0, 5), paveMaterial.method_9564(), true);
            scene.idle(20);
        }
        scene.world().replaceBlocks(util.select().fromTo(0, 0, 3, 0, 0, 5), paveMaterial.method_9564(), true);
        scene.idle(10);
        for (i = 0; i < 3; ++i) {
            scene.world().modifyBlockEntity(util.grid().at(6, 2, 3 + i), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
    }

    public static void fill(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        int j;
        int i2;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_roller_fill", "Filling terrain with the Roller");
        scene.configureBasePlate(0, 0, 9);
        scene.scaleSceneView(0.625f);
        scene.setSceneOffsetY(-3.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 stationPos = util.grid().at(7, 5, 1);
        class_2338 controlsPos = util.grid().at(7, 7, 4);
        class_2338 bogeyPos = util.grid().at(7, 6, 4);
        Selection train = util.select().fromTo(8, 6, 4, 7, 7, 5);
        Selection rollers = util.select().fromTo(6, 6, 3, 6, 6, 5);
        scene.special().movePointOfInterest(util.grid().at(0, 7, 4));
        for (int i3 = 8; i3 >= 0; --i3) {
            scene.world().showSection(util.select().fromTo(i3, 4, 3, i3, 5, 5), class_2350.field_11033);
            scene.idle(1);
        }
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(8, 1, 2, 6, 4, 2), class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(8, 1, 6, 6, 4, 6), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(7, 4, 1, 7, 5, 1), class_2350.field_11035);
        scene.idle(5);
        ElementLink trainLink = scene.world().showIndependentSection(train, class_2350.field_11033);
        ElementLink<ParrotElement> birbLink = scene.special().createBirb(util.vector().centerOf(8, 7, 4), ParrotPose.FacePointOfInterestPose::new);
        scene.idle(5);
        scene.world().showSectionAndMerge(rollers, class_2350.field_11034, trainLink);
        scene.idle(15);
        class_243 filterSlot = util.vector().of(6.6875, 7.0, 3.6875);
        scene.overlay().showFilterSlotInput(filterSlot, class_2350.field_11036, 60);
        scene.overlay().showText(60).pointAt(filterSlot.method_1031(-0.125, 0.0, 0.0)).attachKeyFrame().text("While disassembled, rollers can be set to other modes").placeNearTarget();
        scene.idle(70);
        scene.overlay().showOutlineWithText(util.select().fromTo(5, 3, 3, 0, 1, 5), 90).attachKeyFrame().colored(PonderPalette.BLUE).text("The 'fill' modes can help to bridge gaps between pavement and terrain").placeNearTarget();
        scene.idle(100);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 50).showing((ScreenElement)AllIcons.I_ROLLER_FILL);
        scene.idle(15);
        class_2248 paveMaterial = class_2246.field_10253;
        class_1799 paveItem = new class_1799((class_1935)paveMaterial);
        scene.overlay().showControls(filterSlot.method_1031(0.0, 0.0, -0.375), Pointing.UP, 35).withItem(paveItem);
        scene.idle(7);
        scene.world().setFilterData(rollers, RollerBlockEntity.class, paveItem);
        scene.idle(10);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, false);
        scene.world().toggleControls(controlsPos);
        scene.idle(20);
        scene.world().moveSection(trainLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.special().moveParrot(birbLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().animateBogey(bogeyPos, 5.5f, 110);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < 3; ++i) {
                scene.world().showSection(util.select().fromTo(5 - j, 3 - i, 3, 5 - j, 3 - i, 5), null);
                scene.idle(2);
            }
            if (j == 2) {
                scene.overlay().showText(90).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 3), class_2350.field_11043)).text("On 'straight fill', they will place simple columns down to the surface").placeNearTarget();
            }
            scene.idle(14);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().showSection(util.select().fromTo(0, 3 - i2, 3, 0, 3 - i2, 5), null);
            scene.idle(2);
        }
        scene.idle(4);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.idle(15);
        scene.world().hideSection(util.select().fromTo(5, 1, 3, 0, 3, 5), class_2350.field_11035);
        scene.world().hideIndependentSection(trainLink, class_2350.field_11036);
        scene.special().hideElement(birbLink, class_2350.field_11036);
        scene.idle(15);
        scene.world().toggleControls(controlsPos);
        scene.idle(15);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, true);
        birbLink = scene.special().createBirb(util.vector().centerOf(8, 7, 4), ParrotPose.FacePointOfInterestPose::new);
        trainLink = scene.world().showIndependentSection(train, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSectionAndMerge(rollers, class_2350.field_11034, trainLink);
        scene.idle(25);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 40).showing((ScreenElement)AllIcons.I_ROLLER_WIDE_FILL);
        scene.idle(45);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, false);
        scene.world().toggleControls(controlsPos);
        scene.idle(20);
        scene.world().moveSection(trainLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.special().moveParrot(birbLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().animateBogey(bogeyPos, 5.5f, 110);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < 3; ++i) {
                scene.world().showSection(util.select().fromTo(5 - j, 3 - i, 1, 5 - j, 3 - i, 7), null);
                scene.idle(2);
            }
            if (j == 2) {
                scene.overlay().showText(90).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 3), class_2350.field_11043)).text("On 'sloped fill', layers placed further down will increase in size").placeNearTarget();
            }
            scene.idle(14);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().showSection(util.select().fromTo(0, 3 - i2, 1, 0, 3 - i2, 7), null);
            scene.idle(2);
        }
        scene.idle(4);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
        scene.idle(15);
        scene.world().hideSection(util.select().fromTo(5, 1, 1, 0, 3, 7), class_2350.field_11035);
        scene.world().hideIndependentSection(trainLink, class_2350.field_11036);
        scene.special().hideElement(birbLink, class_2350.field_11036);
        scene.idle(15);
        scene.world().toggleControls(controlsPos);
        scene.world().replaceBlocks(util.select().fromTo(5, 1, 3, 0, 3, 5), class_2246.field_10445.method_9564(), false);
        scene.idle(15);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, true);
        scene.world().showSection(util.select().fromTo(5, 1, 3, 0, 3, 5), class_2350.field_11043);
        birbLink = scene.special().createBirb(util.vector().centerOf(8, 7, 4), ParrotPose.FacePointOfInterestPose::new);
        trainLink = scene.world().showIndependentSection(train, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSectionAndMerge(rollers, class_2350.field_11034, trainLink);
        scene.idle(25);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().animateTrainStation(stationPos, false);
        scene.world().toggleControls(controlsPos);
        scene.idle(20);
        scene.world().moveSection(trainLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.special().moveParrot(birbLink, util.vector().of(-5.5, 0.0, 0.0), 110);
        scene.world().animateBogey(bogeyPos, 5.5f, 110);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(-100.0f));
        }
        scene.overlay().showText(110).attachKeyFrame().independent().text("As opposed to 'clear & pave', neither of these modes will cause the rollers to break existing blocks").placeNearTarget();
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < 3; ++i) {
                scene.world().showSection(util.select().fromTo(5 - j, 3 - i, 1, 5 - j, 3 - i, 7), null);
                scene.idle(2);
            }
            scene.idle(14);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().showSection(util.select().fromTo(0, 3 - i2, 1, 0, 3 - i2, 7), null);
            scene.idle(2);
        }
        scene.rotateCameraY(-30.0f);
        scene.idle(4);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world().modifyBlockEntity(util.grid().at(6, 6, 3 + i2), RollerBlockEntity.class, rte -> rte.setAnimatedSpeed(0.0f));
        }
    }
}

