/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.equipment.goggles;

import com.simibubi.create.api.equipment.goggles.IHaveCustomOverlayIcon;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.FluidTextUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public interface IHaveGoggleInformation
extends IHaveCustomOverlayIcon {
    default public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    default public boolean containedFluidTooltip(List<class_2561> tooltip, boolean isPlayerSneaking, Storage<FluidVariant> handler) {
        if (handler == null) {
            return false;
        }
        FluidUnit unit = (FluidUnit)AllConfigs.client().fluidUnitType.get();
        boolean simplify = (Boolean)AllConfigs.client().simplifyFluidUnit.get();
        LangBuilder mb = CreateLang.translate(unit.getTranslationKey(), new Object[0]);
        CreateLang.translate("gui.goggles.fluid_container", new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        int tanks = 0;
        long firstCapacity = -1L;
        for (StorageView view : handler) {
            if (tanks == 0) {
                firstCapacity = view.getCapacity();
            }
            ++tanks;
            FluidStack fluidStack = new FluidStack(view);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName(fluidStack).style(class_124.field_1080).forGoggles(tooltip, 1);
            String amount = FluidTextUtil.getUnicodeMillibuckets((long)fluidStack.getAmount(), (FluidUnit)unit, (boolean)simplify);
            CreateLang.builder().add(CreateLang.text(amount).add(mb).style(class_124.field_1065)).text(class_124.field_1080, " / ").add(CreateLang.text(FluidTextUtil.getUnicodeMillibuckets((long)view.getCapacity(), (FluidUnit)unit, (boolean)simplify)).add(mb).style(class_124.field_1063)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tanks > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate("gui.goggles.fluid_container.capacity", new Object[0]).add(CreateLang.text(FluidTextUtil.getUnicodeMillibuckets((long)firstCapacity, (FluidUnit)unit, (boolean)simplify)).add(mb).style(class_124.field_1065)).style(class_124.field_1080).forGoggles(tooltip, 1);
        return true;
    }
}

