/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart;

import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class TrainCargoManager
extends MountedStorageManager {
    int ticksSinceLastExchange = 0;
    AtomicInteger version = new AtomicInteger();

    @Override
    public void initialize() {
        super.initialize();
        this.items = new CargoInvWrapper(this.items);
        this.allItems = this.items;
        if (this.fuelItems != null) {
            this.fuelItems = new CargoInvWrapper(this.fuelItems);
        }
        this.fluids = new CargoTankWrapper(this.fluids);
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10569("TicksSinceLastExchange", this.ticksSinceLastExchange);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket, @Nullable Contraption contraption) {
        super.read(nbt, clientPacket, contraption);
        this.ticksSinceLastExchange = nbt.method_10550("TicksSinceLastExchange");
    }

    public void resetIdleCargoTracker() {
        this.ticksSinceLastExchange = 0;
    }

    public void tickIdleCargoTracker() {
        ++this.ticksSinceLastExchange;
    }

    public int getTicksSinceLastExchange() {
        return this.ticksSinceLastExchange;
    }

    public int getVersion() {
        return this.version.get();
    }

    void changeDetected() {
        this.version.incrementAndGet();
        this.resetIdleCargoTracker();
    }

    class CargoInvWrapper
    extends MountedItemStorageWrapper {
        CargoInvWrapper(MountedItemStorageWrapper wrapped) {
            super(wrapped.storages);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((Object)resource, maxAmount, transaction);
            if (inserted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return inserted;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long extracted = super.extract((Object)resource, maxAmount, transaction);
            if (extracted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return extracted;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            return new ProcessingIterator<StorageView<ItemVariant>>(super.iterator(), view -> new ListeningStorageView(view, TrainCargoManager.this::changeDetected));
        }
    }

    class CargoTankWrapper
    extends MountedFluidStorageWrapper {
        CargoTankWrapper(MountedFluidStorageWrapper wrapped) {
            super(wrapped.storages);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            long inserted = super.insert((Object)resource, maxAmount, transaction);
            if (inserted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return inserted;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            long extracted = super.extract((Object)resource, maxAmount, transaction);
            if (extracted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, TrainCargoManager.this::changeDetected);
            }
            return extracted;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return new ProcessingIterator<StorageView<FluidVariant>>(super.iterator(), view -> new ListeningStorageView(view, TrainCargoManager.this::changeDetected));
        }
    }
}

