/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.foundation.item.ItemSlots;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ToolboxInventory
extends ItemStackHandler {
    public static final int STACKS_PER_COMPARTMENT = 4;
    public static final Codec<ToolboxInventory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemSlots.maxSizeCodec(32).fieldOf("items").forGetter(ItemSlots::fromHandler), (App)class_1799.field_24671.listOf().fieldOf("filters").forGetter(toolbox -> toolbox.filters)).apply((Applicative)instance, ToolboxInventory::deserialize));
    List<class_1799> filters;
    boolean settling;
    private ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(ToolboxBlockEntity be) {
        super(32);
        this.blockEntity = be;
        this.limitedMode = false;
        this.filters = new ArrayList<class_1799>();
        this.settling = false;
        for (int i = 0; i < 8; ++i) {
            this.filters.add(class_1799.field_8037);
        }
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public void settle(int compartment) {
        int i;
        int totalCount = 0;
        boolean valid = true;
        boolean shouldBeEmpty = false;
        class_1799 sample = class_1799.field_8037;
        for (i = 0; i < 4; ++i) {
            class_1799 stackInSlot = this.getStackInSlot(compartment * 4 + i);
            totalCount += stackInSlot.method_7947();
            if (!shouldBeEmpty) {
                shouldBeEmpty = stackInSlot.method_7960() || stackInSlot.method_7947() != stackInSlot.method_7914();
                continue;
            }
            if (stackInSlot.method_7960()) continue;
            valid = false;
            sample = stackInSlot;
        }
        if (valid) {
            return;
        }
        this.settling = true;
        if (!sample.method_7946()) {
            block1: for (i = 0; i < 4; ++i) {
                if (!this.getStackInSlot(compartment * 4 + i).method_7960()) continue;
                for (int j = i + 1; j < 4; ++j) {
                    class_1799 stackInSlot = this.getStackInSlot(compartment * 4 + j);
                    if (stackInSlot.method_7960()) continue;
                    this.setStackInSlot(compartment * 4 + i, stackInSlot);
                    this.setStackInSlot(compartment * 4 + j, class_1799.field_8037);
                    continue block1;
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                class_1799 copy = totalCount <= 0 ? class_1799.field_8037 : ItemHandlerHelper.copyStackWithSize((class_1799)sample, (int)Math.min(totalCount, sample.method_7914()));
                this.setStackInSlot(compartment * 4 + i, copy);
                totalCount -= copy.method_7947();
            }
        }
        this.settling = false;
        this.notifyUpdate();
    }

    public boolean isItemValid(int slot, ItemVariant var, int count) {
        class_1799 stack = var.toStack();
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        if (slot < 0 || slot >= this.getSlotCount()) {
            return false;
        }
        int compartment = slot / 4;
        class_1799 filter = this.filters.get(compartment);
        if (this.limitedMode && filter.method_7960()) {
            return false;
        }
        if (filter.method_7960() || ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return super.isItemValid(slot, var, count);
        }
        return false;
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        super.setStackInSlot(slot, stack);
        this.updateCompartmentFilters(slot, stack, null);
    }

    private void updateCompartmentFilters(int slot, class_1799 stack, @Nullable TransactionContext ctx) {
        int compartment = slot / 4;
        if (!stack.method_7960() && this.filters.get(compartment).method_7960()) {
            this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1));
            if (ctx != null) {
                TransactionCallback.onSuccess((TransactionContext)ctx, this.blockEntity::notifyUpdate);
            } else {
                this.notifyUpdate();
            }
        }
    }

    public class_2487 serializeNBT() {
        class_2487 compound = super.serializeNBT();
        compound.method_10566("Compartments", (class_2520)NBTHelper.writeItemList(this.filters));
        return compound;
    }

    protected void onContentsChanged(int slot) {
        if (!(this.settling || this.blockEntity != null && this.blockEntity.method_10997().field_9236)) {
            this.settle(slot / 4);
        }
        this.notifyUpdate();
        super.onContentsChanged(slot);
        class_1799 stack = this.getStackInSlot(slot);
        this.updateCompartmentFilters(slot, stack, null);
    }

    public void deserializeNBT(class_2487 nbt) {
        this.filters = NBTHelper.readItemList((class_2499)nbt.method_10554("Compartments", 10));
        if (this.filters.size() != 8) {
            this.filters.clear();
            for (int i = 0; i < 8; ++i) {
                this.filters.add(class_1799.field_8037);
            }
        }
        super.deserializeNBT(nbt);
    }

    public class_1799 distributeToCompartment(@Nonnull class_1799 stack, int compartment, TransactionContext ctx) {
        int slot;
        if (stack.method_7960()) {
            return stack;
        }
        if (this.filters.get(compartment).method_7960()) {
            return stack;
        }
        int toInsert = stack.method_7947();
        int inserted = 0;
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        for (int i = 3; i >= 0 && (inserted = (int)((long)inserted + this.getSlot(slot = compartment * 4 + i).insert(variant, (long)(toInsert - inserted), ctx))) < toInsert; --i) {
        }
        return ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(toInsert - inserted));
    }

    public class_1799 takeFromCompartment(int amount, int compartment, TransactionContext ctx) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        ItemVariant toExtract = null;
        int extracted = 0;
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            ItemStackHandlerSlot handlerSlot = this.getSlot(slot);
            if (handlerSlot.isResourceBlank()) continue;
            if (toExtract == null) {
                toExtract = handlerSlot.getResource();
            }
            if ((extracted = (int)((long)extracted + handlerSlot.extract(toExtract, (long)(amount - extracted), ctx))) >= amount) break;
        }
        return toExtract == null || extracted == 0 ? class_1799.field_8037 : toExtract.toStack(extracted);
    }

    public static class_1799 cleanItemNBT(class_1799 stack) {
        if (AllItems.BELT_CONNECTOR.isIn(stack)) {
            stack.method_7983("FirstPulley");
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() && !stack2.method_7946() && stack1.method_7963() && stack2.method_7963()) {
            return stack1.method_7909() == stack2.method_7909();
        }
        if (AllItems.BELT_CONNECTOR.isIn(stack1) && AllItems.BELT_CONNECTOR.isIn(stack2)) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((class_1799)stack1, (class_1799)stack2);
    }

    private void notifyUpdate() {
        if (this.blockEntity != null) {
            this.blockEntity.notifyUpdate();
        }
    }

    private static ToolboxInventory deserialize(ItemSlots slots, List<class_1799> filters) {
        ToolboxInventory inventory = new ToolboxInventory(null);
        slots.forEach(inventory::setStackInSlot);
        inventory.filters = new ArrayList<class_1799>(filters);
        return inventory;
    }
}

