/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.fabric.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.item.EntitySwingListenerItem;
import io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.nbt.NBTProcessors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_572;
import net.minecraft.class_742;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class ZapperItem
extends class_1792
implements CustomArmPoseItem,
EntitySwingListenerItem,
ReequipAnimationItem {
    public ZapperItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_7985() && stack.method_7969().method_10545("BlockUsed")) {
            class_5250 usedBlock = class_2512.method_10681((class_7871)worldIn.method_45448(class_7924.field_41254), (class_2487)stack.method_7969().method_10562("BlockUsed")).method_26204().method_9518();
            tooltip.add((class_2561)CreateLang.translateDirect("terrainzapper.usingBlock", usedBlock.method_27692(class_124.field_1080)).method_27692(class_124.field_1063));
        }
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        boolean differentBlock = false;
        if (oldStack.method_7985() && newStack.method_7985() && oldStack.method_7969().method_10545("BlockUsed") && newStack.method_7969().method_10545("BlockUsed")) {
            differentBlock = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)oldStack.method_7969().method_10562("BlockUsed")) != class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)newStack.method_7969().method_10562("BlockUsed"));
        }
        return slotChanged || !this.isZapper(newStack) || differentBlock;
    }

    public boolean isZapper(class_1799 newStack) {
        return newStack.method_7909() instanceof ZapperItem;
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            if (context.method_8045().field_9236) {
                EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.openHandgunGUI(context.method_8041(), context.method_20287()));
                context.method_8036().method_7357().method_7906(context.method_8041().method_7909(), 10);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        boolean mainHand;
        class_1799 item = player.method_5998(hand);
        class_2487 nbt = item.method_7948();
        boolean bl = mainHand = hand == class_1268.field_5808;
        if (player.method_5715()) {
            if (world.field_9236) {
                EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.openHandgunGUI(item, hand));
                player.method_7357().method_7906(item.method_7909(), 10);
            }
            return new class_1271(class_1269.field_5812, (Object)item);
        }
        if (ShootableGadgetItemMethods.shouldSwap(player, item, hand, this::isZapper)) {
            return new class_1271(class_1269.field_5814, (Object)item);
        }
        class_2561 msg = this.validateUsage(item);
        if (msg != null) {
            AllSoundEvents.DENY.play(world, player, (class_2382)player.method_24515());
            player.method_7353((class_2561)msg.method_27662().method_27692(class_124.field_1061), true);
            return new class_1271(class_1269.field_5814, (Object)item);
        }
        class_2680 stateToUse = class_2246.field_10124.method_9564();
        if (nbt.method_10545("BlockUsed")) {
            stateToUse = class_2512.method_10681((class_7871)world.method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("BlockUsed"));
        }
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        class_2487 data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(stateToUse) && nbt.method_10573("BlockData", 10)) {
            data = nbt.method_10562("BlockData");
        }
        class_243 start = player.method_19538().method_1031(0.0, (double)player.method_5751(), 0.0);
        class_243 range = player.method_5720().method_1021((double)this.getZappingRange(item));
        class_3965 raytrace = world.method_17742(new class_3959(start, start.method_1019(range), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        class_2338 pos = raytrace.method_17777();
        class_2680 stateReplaced = world.method_8320(pos);
        if (pos == null || stateReplaced.method_26204() == class_2246.field_10124) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            return new class_1271(class_1269.field_5812, (Object)item);
        }
        class_243 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, mainHand, new class_243((double)0.35f, (double)-0.1f, 1.0));
        if (world.field_9236) {
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new class_1271(class_1269.field_5812, (Object)item);
        }
        if (this.activate(world, player, item, stateToUse, raytrace, data)) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            ShootableGadgetItemMethods.sendPackets(player, b -> new ZapperBeamPacket(barrelPos, raytrace.method_17784(), hand, (boolean)b));
        }
        return new class_1271(class_1269.field_5812, (Object)item);
    }

    public class_2561 validateUsage(class_1799 item) {
        class_2487 tag = item.method_7948();
        if (!this.canActivateWithoutSelectedBlock(item) && !tag.method_10545("BlockUsed")) {
            return CreateLang.translateDirect("terrainzapper.leftClickToSet", new Object[0]);
        }
        return null;
    }

    protected abstract boolean activate(class_1937 var1, class_1657 var2, class_1799 var3, class_2680 var4, class_3965 var5, class_2487 var6);

    @Environment(value=EnvType.CLIENT)
    protected abstract void openHandgunGUI(class_1799 var1, class_1268 var2);

    protected abstract int getCooldownDelay(class_1799 var1);

    protected abstract int getZappingRange(class_1799 var1);

    protected boolean canActivateWithoutSelectedBlock(class_1799 stack) {
        return false;
    }

    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return true;
    }

    public boolean method_7885(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player) {
        return false;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    @Override
    @Nullable
    public class_572.class_573 getArmPose(class_1799 stack, class_742 player, class_1268 hand) {
        if (!player.field_6252) {
            return class_572.class_573.field_3408;
        }
        return null;
    }

    public static void configureSettings(class_1799 stack, PlacementPatterns pattern) {
        class_2487 nbt = stack.method_7948();
        NBTHelper.writeEnum((class_2487)nbt, (String)"Pattern", (Enum)pattern);
    }

    public static void setBlockEntityData(class_1937 world, class_2338 pos, class_2680 state, class_2487 data, class_1657 player) {
        class_2586 blockEntity;
        if (data != null && AllTags.AllBlockTags.SAFE_NBT.matches(state) && (blockEntity = world.method_8321(pos)) != null) {
            if ((data = NBTProcessors.process((class_2680)state, (class_2586)blockEntity, (class_2487)data, (!player.method_7337() ? 1 : 0) != 0)) == null) {
                return;
            }
            data.method_10569("x", pos.method_10263());
            data.method_10569("y", pos.method_10264());
            data.method_10569("z", pos.method_10260());
            blockEntity.method_11014(data);
        }
    }
}

