/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltRenderer;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BeltVisual
extends KineticBlockEntityVisual<BeltBlockEntity> {
    public static final float MAGIC_SCROLL_MULTIPLIER = 0.001984127f;
    public static final float SCROLL_FACTOR_DIAGONAL = 0.375f;
    public static final float SCROLL_FACTOR_OTHERWISE = 0.5f;
    public static final float SCROLL_OFFSET_BOTTOM = 0.5f;
    public static final float SCROLL_OFFSET_OTHERWISE = 0.0f;
    protected final ScrollInstance[] belts;
    @Nullable
    protected final RotatingInstance pulley;

    public BeltVisual(VisualizationContext context, BeltBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        BeltPart part = (BeltPart)((Object)this.blockState.method_11654(BeltBlock.PART));
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        class_1767 color = blockEntity.color.orElse(null);
        boolean diagonal = ((BeltSlope)((Object)this.blockState.method_11654(BeltBlock.SLOPE))).isDiagonal();
        this.belts = new ScrollInstance[diagonal ? 1 : 2];
        for (boolean bottom : Iterate.trueAndFalse) {
            PartialModel beltPartial = BeltRenderer.getBeltPartial(diagonal, start, end, bottom);
            SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);
            Instancer beltModel = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)beltPartial));
            this.belts[bottom ? 0 : 1] = this.setup((ScrollInstance)beltModel.createInstance(), bottom, spriteShift);
            if (diagonal) break;
        }
        if (blockEntity.hasPulley()) {
            this.pulley = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, this.getPulleyModel()).createInstance();
            this.pulley.setup((KineticBlockEntity)this.blockEntity).setPosition((class_2382)this.getVisualPosition()).setChanged();
        } else {
            this.pulley = null;
        }
    }

    public void update(float pt) {
        class_1767 color = ((BeltBlockEntity)this.blockEntity).color.orElse(null);
        boolean diagonal = ((BeltSlope)((Object)this.blockState.method_11654(BeltBlock.SLOPE))).isDiagonal();
        boolean bottom = true;
        for (ScrollInstance key : this.belts) {
            this.setup(key, bottom, BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom));
            bottom = false;
        }
        if (this.pulley != null) {
            this.pulley.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.belts);
        if (this.pulley != null) {
            this.relight(new FlatLit[]{this.pulley});
        }
    }

    protected void _delete() {
        for (ScrollInstance key : this.belts) {
            key.delete();
        }
        if (this.pulley != null) {
            this.pulley.delete();
        }
    }

    private Model getPulleyModel() {
        class_2350 dir = this.getOrientation();
        return Models.partial((PartialModel)AllPartialModels.BELT_PULLEY, (Object)dir.method_10166(), (axis11, modelTransform1) -> {
            PoseTransformStack msr = TransformStack.of((class_4587)modelTransform1);
            msr.center();
            if (axis11 == class_2350.class_2351.field_11048) {
                msr.rotateYDegrees(90.0f);
            }
            if (axis11 == class_2350.class_2351.field_11052) {
                msr.rotateXDegrees(90.0f);
            }
            msr.rotateXDegrees(90.0f);
            msr.uncenter();
        });
    }

    private class_2350 getOrientation() {
        class_2350 dir = ((class_2350)this.blockState.method_11654(BeltBlock.HORIZONTAL_FACING)).method_10170();
        if (this.blockState.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS) {
            dir = class_2350.field_11036;
        }
        return dir;
    }

    private ScrollInstance setup(ScrollInstance key, boolean bottom, SpriteShiftEntry spriteShift) {
        BeltSlope beltSlope = (BeltSlope)((Object)this.blockState.method_11654(BeltBlock.SLOPE));
        class_2350 facing = (class_2350)this.blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
        boolean diagonal = beltSlope.isDiagonal();
        boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
        boolean vertical = beltSlope == BeltSlope.VERTICAL;
        boolean upward = beltSlope == BeltSlope.UPWARD;
        boolean alongX = facing.method_10166() == class_2350.class_2351.field_11048;
        boolean alongZ = facing.method_10166() == class_2350.class_2351.field_11051;
        boolean downward = beltSlope == BeltSlope.DOWNWARD;
        float speed = ((BeltBlockEntity)this.blockEntity).getSpeed();
        if (facing.method_10171() == class_2350.class_2352.field_11060 ^ upward ^ (alongX && !diagonal || alongZ && diagonal)) {
            speed = -speed;
        }
        if (sideways && (facing == class_2350.field_11035 || facing == class_2350.field_11039) || vertical && facing == class_2350.field_11034) {
            speed = -speed;
        }
        float rotX = (!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90 : 0) + (downward ? 180 : 0) + (sideways ? 90 : 0) + (vertical && alongZ ? 180 : 0);
        float rotY = facing.method_10144() + (float)(diagonal ^ alongX && !downward ? 180 : 0) + (float)(sideways && alongZ ? 180 : 0) + (float)(vertical && alongX ? 90 : 0);
        float rotZ = (sideways ? 90 : 0) + (vertical && alongX ? 90 : 0);
        Quaternionf q = new Quaternionf().rotationXYZ(rotX * ((float)Math.PI / 180), rotY * ((float)Math.PI / 180), rotZ * ((float)Math.PI / 180));
        key.setSpriteShift(spriteShift, 1.0f, diagonal ? 0.375f : 0.5f).position((class_2382)this.getVisualPosition()).rotation((Quaternionfc)q).speed(0.0f, speed * 0.001984127f).offset(0.0f, bottom ? 0.5f : 0.0f).colorRgb(RotatingInstance.colorFromBE((KineticBlockEntity)this.blockEntity)).setChanged();
        return key;
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.pulley != null) {
            consumer.accept((Instance)this.pulley);
        }
        for (ScrollInstance key : this.belts) {
            consumer.accept((Instance)key);
        }
    }
}

