/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class SawRenderer
extends SafeBlockEntityRenderer<SawBlockEntity> {
    public SawRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        this.renderBlade(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light) {
        PartialModel partial;
        class_2680 blockState = be.method_11010();
        float speed = be.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = be.getSpeed() > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)partial, (class_2680)blockState);
        if (rotate) {
            superBuffer.rotateCentered(AngleHelper.rad((double)90.0), class_2350.field_11036);
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    protected void renderShaft(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer(be, this.getRotatedModel(be), ms, buffer.getBuffer(class_1921.method_23577()), light);
    }

    protected void renderItems(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (be.method_11010().method_11654((class_2769)SawBlock.FACING) != class_2350.field_11036) {
            return;
        }
        if (be.inventory.method_5442()) {
            return;
        }
        boolean alongZ = (Boolean)be.method_11010().method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        float duration = be.inventory.recipeDuration;
        boolean moving = duration != 0.0f;
        float offset = moving ? be.inventory.remainingTime / duration : 0.0f;
        float processingSpeed = class_3532.method_15363((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
        if (moving) {
            offset = class_3532.method_15363((float)(offset + (-partialTicks + 0.5f) * processingSpeed / duration), (float)0.125f, (float)1.0f);
            if (!be.inventory.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (be.getSpeed() == 0.0f) {
            offset = 0.5f;
        }
        if (be.getSpeed() < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        int outputs = 0;
        for (int i = 1; i < be.inventory.getSlotCount(); ++i) {
            if (be.inventory.getStackInSlot(i).method_7960()) continue;
            ++outputs;
        }
        ms.method_22903();
        if (alongZ) {
            ms.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        }
        ms.method_22904(outputs <= 1 ? 0.5 : 0.25, 0.0, (double)offset);
        ms.method_46416(alongZ ? -1.0f : 0.0f, 0.0f, 0.0f);
        int renderedI = 0;
        for (int i = 0; i < be.inventory.getSlotCount(); ++i) {
            boolean box;
            class_1799 stack = be.inventory.getStackInSlot(i);
            if (stack.method_7960()) continue;
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1087 modelWithOverrides = itemRenderer.method_4019(stack, be.method_10997(), null, 0);
            boolean blockItem = modelWithOverrides.method_4712();
            ms.method_22903();
            ms.method_46416(0.0f, blockItem ? 0.925f : 0.8125f, 0.0f);
            if (i > 0 && outputs > 1) {
                ms.method_22904(0.5 / (double)(outputs - 1) * (double)renderedI, 0.0, 0.0);
                TransformStack.of((class_4587)ms).nudge(i * 133);
            }
            if (box = PackageItem.isPackage(stack)) {
                ms.method_46416(0.0f, 0.25f, 0.0f);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else {
                ms.method_22905(0.5f, 0.5f, 0.5f);
            }
            if (!box) {
                ms.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
            itemRenderer.method_23179(stack, class_811.field_4319, false, ms, buffer, light, overlay, modelWithOverrides);
            ++renderedI;
            ms.method_22909();
        }
        ms.method_22909();
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        class_2680 state = be.method_11010();
        if (((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().method_10179()) {
            return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (class_2680)state.method_26186(class_2470.field_11464));
        }
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, (class_2680)this.getRenderedBlockState(be));
    }

    protected class_2680 getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        boolean shouldAnimate;
        class_2680 state = context.state;
        class_2350 facing = (class_2350)state.method_11654((class_2769)SawBlock.FACING);
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        boolean horizontal = closestToFacing.method_10166().method_10179();
        boolean backwards = VecHelper.isVecPointingTowards((class_243)context.relativeMotion, (class_2350)facing.method_10153());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = SawBlock.isHorizontal(state) ? (shouldAnimate ? CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE, (class_2680)state) : CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, (class_2680)state)) : (shouldAnimate ? CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE, (class_2680)state) : CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, (class_2680)state));
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((class_2350)facing))).rotateXDegrees(AngleHelper.verticalAngle((class_2350)facing));
        if (!SawBlock.isHorizontal(state)) {
            superBuffer.rotateZDegrees((Boolean)state.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0f : 0.0f);
        }
        ((SuperByteBuffer)superBuffer.uncenter()).light(class_761.method_23794((class_1920)renderWorld, (class_2338)context.localPos)).useLevelLight((class_1920)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23579()));
    }
}

