/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class InItemGroupAttribute
implements ItemAttribute {
    private class_1761 group;

    public InItemGroupAttribute(class_1761 group) {
        this.group = group;
    }

    private static boolean tabContainsItem(class_1761 tab, class_1799 stack) {
        return tab.method_45412(stack) || tab.method_45412(new class_1799((class_1935)stack.method_7909()));
    }

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 world) {
        if (this.group == null) {
            return false;
        }
        if (this.group.method_47313().isEmpty() && this.group.method_45414().isEmpty()) {
            try {
                this.group.method_47306(new class_1761.class_8128(world.method_45162(), false, (class_7225.class_7874)world.method_30349()));
            }
            catch (LinkageError | RuntimeException e) {
                Create.LOGGER.error("Attribute Filter: Item Group {} crashed while building contents.", (Object)this.group.method_7737().getString(), (Object)e);
                this.group = null;
                return false;
            }
        }
        return InItemGroupAttribute.tabContainsItem(this.group, stack);
    }

    @Override
    public String getTranslationKey() {
        return "in_item_group";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.group == null ? "<none>" : this.group.method_7737().getString()};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.IN_ITEM_GROUP;
    }

    @Override
    public void save(class_2487 nbt) {
        class_2960 groupId;
        if (this.group != null && (groupId = class_7923.field_44687.method_10221((Object)this.group)) != null) {
            nbt.method_10582("group", groupId.toString());
        }
    }

    @Override
    public void load(class_2487 nbt) {
        if (nbt.method_10545("group")) {
            this.group = (class_1761)class_7923.field_44687.method_10223(new class_2960(nbt.method_10558("group")));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new InItemGroupAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (class_1761 tab : class_7706.method_47335()) {
                if (tab.method_47312() != class_1761.class_7916.field_41052 || !InItemGroupAttribute.tabContainsItem(tab, stack)) continue;
                list.add(new InItemGroupAttribute(tab));
            }
            return list;
        }
    }
}

