/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import org.slf4j.Logger;

@class_6328
@ParametersAreNonnullByDefault
public abstract class ProcessingRecipe<T extends class_1263>
implements class_1860<T> {
    protected class_2960 id;
    protected class_2371<class_1856> ingredients;
    protected class_2371<ProcessingOutput> results;
    protected class_2371<FluidIngredient> fluidIngredients;
    protected class_2371<FluidStack> fluidResults;
    protected int processingDuration;
    protected HeatCondition requiredHeat;
    private class_3956<?> type;
    private class_1865<?> serializer;
    private IRecipeTypeInfo typeInfo;
    private Supplier<class_1799> forcedResult = null;

    public ProcessingRecipe(IRecipeTypeInfo typeInfo, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this.typeInfo = typeInfo;
        this.processingDuration = params.processingDuration;
        this.fluidIngredients = params.fluidIngredients;
        this.fluidResults = params.fluidResults;
        this.serializer = typeInfo.getSerializer();
        this.requiredHeat = params.requiredHeat;
        this.ingredients = params.ingredients;
        this.type = typeInfo.getType();
        this.results = params.results;
        this.id = params.id;
        this.validate(typeInfo.getId());
    }

    protected abstract int getMaxInputCount();

    protected abstract int getMaxOutputCount();

    protected boolean canRequireHeat() {
        return false;
    }

    protected boolean canSpecifyDuration() {
        return false;
    }

    protected int getMaxFluidInputCount() {
        return 0;
    }

    protected int getMaxFluidOutputCount() {
        return 0;
    }

    private void validate(class_2960 recipeTypeId) {
        String messageHeader = "Your custom " + String.valueOf(recipeTypeId) + " recipe (" + this.id.toString() + ")";
        Logger logger = Create.LOGGER;
        int ingredientCount = this.ingredients.size();
        int outputCount = this.results.size();
        if (ingredientCount > this.getMaxInputCount()) {
            logger.warn(messageHeader + " has more item inputs (" + ingredientCount + ") than supported (" + this.getMaxInputCount() + ").");
        }
        if (outputCount > this.getMaxOutputCount()) {
            logger.warn(messageHeader + " has more item outputs (" + outputCount + ") than supported (" + this.getMaxOutputCount() + ").");
        }
        if (this.processingDuration > 0 && !this.canSpecifyDuration()) {
            logger.warn(messageHeader + " specified a duration. Durations have no impact on this type of recipe.");
        }
        if (this.requiredHeat != HeatCondition.NONE && !this.canRequireHeat()) {
            logger.warn(messageHeader + " specified a heat condition. Heat conditions have no impact on this type of recipe.");
        }
        ingredientCount = this.fluidIngredients.size();
        outputCount = this.fluidResults.size();
        if (ingredientCount > this.getMaxFluidInputCount()) {
            logger.warn(messageHeader + " has more fluid inputs (" + ingredientCount + ") than supported (" + this.getMaxFluidInputCount() + ").");
        }
        if (outputCount > this.getMaxFluidOutputCount()) {
            logger.warn(messageHeader + " has more fluid outputs (" + outputCount + ") than supported (" + this.getMaxFluidOutputCount() + ").");
        }
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public class_2371<FluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public class_2371<FluidStack> getFluidResults() {
        return this.fluidResults;
    }

    public List<class_1799> getRollableResultsAsItemStacks() {
        return this.getRollableResults().stream().map(ProcessingOutput::getStack).collect(Collectors.toList());
    }

    public void enforceNextResult(Supplier<class_1799> stack) {
        this.forcedResult = stack;
    }

    public List<class_1799> rollResults() {
        return this.rollResults(this.getRollableResults());
    }

    public List<class_1799> rollResults(List<ProcessingOutput> rollableResults) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            class_1799 stack;
            ProcessingOutput output = rollableResults.get(i);
            class_1799 class_17992 = stack = i == 0 && this.forcedResult != null ? this.forcedResult.get() : output.rollOutput();
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }

    public HeatCondition getRequiredHeat() {
        return this.requiredHeat;
    }

    public class_1799 method_8116(T inv, class_5455 registryAccess) {
        return this.method_8110(registryAccess);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.getRollableResults().isEmpty() ? class_1799.field_8037 : this.getRollableResults().get(0).getStack();
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return "processing";
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return this.serializer;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public IRecipeTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void readAdditional(JsonObject json) {
    }

    public void readAdditional(class_2540 buffer) {
    }

    public void writeAdditional(JsonObject json) {
    }

    public void writeAdditional(class_2540 buffer) {
    }
}

