/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack compareStack = FilterItemStack.empty();

    @Override
    protected class_2561 getUnit() {
        return class_2561.method_43470((String)"b");
    }

    @Override
    protected class_1799 getIcon() {
        return this.compareStack.item();
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        long target = this.getThreshold();
        long foundFluid = 0L;
        for (Carriage carriage : train.carriages) {
            MountedFluidStorageWrapper fluids = carriage.storage.getFluids();
            for (StorageView view : fluids.nonEmptyViews()) {
                FluidStack fluidInTank = new FluidStack(view);
                if (!this.compareStack.test(level, fluidInTank)) continue;
                foundFluid += fluidInTank.getAmount();
            }
        }
        this.requestStatusToUpdate(foundFluid / 81000L, context);
        return operator.test(foundFluid, target * 81000L);
    }

    @Override
    protected void writeAdditional(class_2487 tag) {
        super.writeAdditional(tag);
        tag.method_10566("Bucket", (class_2520)this.compareStack.serializeNBT());
    }

    @Override
    protected void readAdditional(class_2487 tag) {
        super.readAdditional(tag);
        if (tag.method_10545("Bucket")) {
            this.compareStack = FilterItemStack.of(tag.method_10562("Bucket"));
        }
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    @Environment(value=EnvType.CLIENT)
    private FluidStack loadFluid() {
        return this.compareStack.fluid((class_1937)class_310.method_1551().field_1687);
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.train_holds", CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name()), new Object[0])), (Object)CreateLang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]), this.compareStack.isEmpty() ? CreateLang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.compareStack.isFilterItem() ? CreateLang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.loadFluid().getDisplayName())).method_27692(class_124.field_1062));
    }

    @Override
    public void setItem(int slot, class_1799 stack) {
        this.compareStack = FilterItemStack.of(stack);
    }

    @Override
    public class_1799 getItem(int slot) {
        return this.compareStack.item();
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("fluid_threshold");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends class_2561>)ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]))).titled(null), "Measure");
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        long lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1L) {
            return class_2561.method_43473();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return CreateLang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0L, this.getThreshold() + (long)offset), CreateLang.translateDirect("schedule.condition.threshold.buckets", new Object[0]));
    }
}

