/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.animatedContainer;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;

public class AnimatedContainerBehaviour<M extends MenuBase<? extends SmartBlockEntity>>
extends BlockEntityBehaviour {
    public static final BehaviourType<AnimatedContainerBehaviour<?>> TYPE = new BehaviourType();
    public int openCount;
    private Class<M> menuClass;
    private Consumer<Boolean> openChanged;

    public AnimatedContainerBehaviour(SmartBlockEntity be, Class<M> menuClass) {
        super(be);
        this.menuClass = menuClass;
        this.openCount = 0;
    }

    public void onOpenChanged(Consumer<Boolean> openChanged) {
        this.openChanged = openChanged;
    }

    @Override
    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.openCount = compound.method_10550("OpenCount");
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.method_10569("OpenCount", this.openCount);
        }
    }

    @Override
    public void lazyTick() {
        this.updateOpenCount();
        super.lazyTick();
    }

    void updateOpenCount() {
        class_1937 level = this.getWorld();
        if (level.field_9236) {
            return;
        }
        if (this.openCount == 0) {
            return;
        }
        int prevOpenCount = this.openCount;
        this.openCount = 0;
        for (class_1657 playerentity : level.method_18467(class_1657.class, new class_238(this.getPos()).method_1014(8.0))) {
            if (!this.menuClass.isInstance(playerentity.field_7512) || ((MenuBase)((Object)this.menuClass.cast((Object)playerentity.field_7512))).contentHolder != this.blockEntity) continue;
            ++this.openCount;
        }
        if (prevOpenCount != this.openCount) {
            if (this.openChanged != null && prevOpenCount == 0 && this.openCount > 0) {
                this.openChanged.accept(true);
            }
            if (this.openChanged != null && prevOpenCount > 0 && this.openCount == 0) {
                this.openChanged.accept(false);
            }
            this.blockEntity.sendData();
        }
    }

    public void startOpen(class_1657 player) {
        if (player.method_7325()) {
            return;
        }
        if (this.getWorld().field_9236) {
            return;
        }
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        if (this.openCount == 1 && this.openChanged != null) {
            this.openChanged.accept(true);
        }
        this.blockEntity.sendData();
    }

    public void stopOpen(class_1657 player) {
        if (player.method_7325()) {
            return;
        }
        if (this.getWorld().field_9236) {
            return;
        }
        --this.openCount;
        if (this.openCount == 0 && this.openChanged != null) {
            this.openChanged.accept(false);
        }
        this.blockEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

