/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.impl.contraption.dispenser;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedProjectileDispenseBehavior;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.dispenser.ContraptionBlockSource;
import com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor;
import io.github.fabricators_of_create.porting_lib.event.common.TagsUpdatedCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public enum DispenserBehaviorConverter implements SimpleRegistry.Provider<class_1792, MountedDispenseBehavior>
{
    INSTANCE;


    @Override
    @Nullable
    public MountedDispenseBehavior get(class_1792 item) {
        class_2357 vanilla = DispenserBehaviorConverter.getDispenseMethod(new class_1799((class_1935)item));
        if (vanilla == null) {
            return null;
        }
        if (vanilla.getClass() == class_2347.class) {
            return null;
        }
        if (AllTags.AllItemTags.DISPENSE_BEHAVIOR_WRAP_BLACKLIST.matches(item)) {
            return null;
        }
        if (vanilla instanceof class_2965) {
            class_2965 projectile = (class_2965)vanilla;
            return MountedProjectileDispenseBehavior.of(projectile);
        }
        return new FallbackBehavior(item, vanilla);
    }

    @Override
    public void onRegister(Runnable invalidate) {
        TagsUpdatedCallback.EVENT.register(registries -> invalidate.run());
    }

    @Nullable
    private static class_2357 getDispenseMethod(class_1799 stack) {
        return ((DispenserBlockAccessor)class_2246.field_10200).create$callGetDispenseMethod(stack);
    }

    private static final class FallbackBehavior
    extends DefaultMountedDispenseBehavior {
        private final class_1792 item;
        private final class_2357 wrapped;
        private boolean hasErrored;

        private FallbackBehavior(class_1792 item, class_2357 wrapped) {
            this.item = item;
            this.wrapped = wrapped;
        }

        @Override
        protected class_1799 execute(class_1799 stack, MovementContext context, class_2338 pos, class_243 facing) {
            if (this.hasErrored) {
                return stack;
            }
            class_2350 nearestFacing = MountedDispenseBehavior.getClosestFacingDirection(facing);
            ContraptionBlockSource source = new ContraptionBlockSource(context, pos, nearestFacing);
            try {
                return this.wrapped.dispense((class_2342)source, stack.method_7972());
            }
            catch (NullPointerException e) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)this.item);
                String message = "Error dispensing item '" + String.valueOf(itemId) + "' from contraption, not doing that anymore";
                Create.LOGGER.error(message, (Throwable)e);
                this.hasErrored = true;
                return stack;
            }
        }
    }
}

