/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5321;

public class TrainCommand {
    static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"train").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"train", (ArgumentType)class_5242.method_27643()).executes(ctx -> TrainCommand.runDelete((class_2168)ctx.getSource(), class_5242.method_27645((CommandContext)ctx, (String)"train")))))).then(class_2170.method_9247((String)"tp").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"train", (ArgumentType)class_5242.method_27643()).requires(class_2168::method_43737)).executes(ctx -> TrainCommand.runTeleport((class_2168)ctx.getSource(), class_5242.method_27645((CommandContext)ctx, (String)"train")))));
    }

    private static int runDelete(class_2168 source, UUID argument) {
        Train train = Create.RAILWAYS.trains.get(argument);
        if (train == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No Train with id " + argument.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        train.invalid = true;
        source.method_9226(() -> class_2561.method_43470((String)"Train '").method_10852(train.name).method_27693("' removed successfully"), true);
        return 1;
    }

    private static int runTeleport(class_2168 source, UUID argument) throws CommandSyntaxException {
        class_3222 serverPlayer = source.method_9207();
        class_1934 gameMode = serverPlayer.field_13974.method_14257();
        if (gameMode != class_1934.field_9220 && gameMode != class_1934.field_9219) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Can only teleport to train when in Creative or Spectator Mode!"));
            return 0;
        }
        Train train = Create.RAILWAYS.trains.get(argument);
        if (train == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("No Train with id " + argument.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        List<class_5321<class_1937>> presentDimensions = train.getPresentDimensions();
        if (presentDimensions.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Unable to teleport to Train. No valid location found"));
            return 0;
        }
        class_5321<class_1937> levelKey = presentDimensions.get(0);
        class_3218 serverLevel = serverPlayer.method_5682().method_3847(levelKey);
        Optional<class_2338> positionInDimension = train.getPositionInDimension(levelKey);
        if (positionInDimension.isEmpty() || serverLevel == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Unable to teleport to Train. No valid location found"));
            return 0;
        }
        class_2338 pos = positionInDimension.get();
        serverPlayer.method_14251(serverLevel, (double)pos.method_10263(), (double)(pos.method_10264() + 5), (double)pos.method_10260(), serverPlayer.method_5705(0.0f), serverPlayer.method_5695(0.0f));
        source.method_9226(() -> class_2561.method_43470((String)"Teleported to Train '").method_10852(train.name).method_27693("' successfully"), true);
        return 1;
    }
}

