/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ChainDriveScenes {
    public static void chainDriveAsRelay(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("chain_drive", "Relaying rotational force with Chain Drives");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 gaugePos = util.grid().at(0, 1, 3);
        Selection gauge = util.select().position(gaugePos);
        scene.world().showSection(gauge, class_2350.field_11036);
        scene.world().setKineticSpeed(gauge, 0.0f);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(5, 1, 2, 4, 1, 2), class_2350.field_11033);
        scene.idle(10);
        for (int i = 0; i < 3; ++i) {
            scene.idle(5);
            scene.world().showSection(util.select().position(3, 1, 2 - i), class_2350.field_11033);
            if (i == 0) continue;
            scene.world().showSection(util.select().position(3, 1, 2 + i), class_2350.field_11033);
        }
        scene.idle(10);
        scene.world().showSection(util.select().position(gaugePos.method_10089(2)), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(gaugePos.method_10078()), class_2350.field_11033);
        scene.idle(5);
        scene.world().setKineticSpeed(gauge, 64.0f);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(20);
        scene.overlay().showText(60).text("Chain Drives relay rotation to each other in a row").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 4), class_2350.field_11039));
        scene.idle(60);
        Selection shafts = util.select().fromTo(2, 1, 0, 2, 1, 1);
        class_2338 rotatedECD = util.grid().at(3, 1, 0);
        Selection verticalShaft = util.select().fromTo(rotatedECD.method_10084(), rotatedECD.method_10086(2));
        scene.world().showSection(shafts, class_2350.field_11034);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(util.grid().at(2, 1, 0));
        scene.effects().rotationDirectionIndicator(util.grid().at(2, 1, 1));
        scene.idle(20);
        scene.overlay().showText(60).text("All shafts connected like this will rotate in the same direction").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(2, 1, 1), class_2350.field_11039));
        scene.idle(50);
        scene.world().hideSection(shafts, class_2350.field_11039);
        scene.idle(25);
        scene.addKeyframe();
        scene.overlay().showControls(util.vector().topOf(rotatedECD), Pointing.DOWN, 30).rightClick().withItem(AllItems.WRENCH.asStack());
        scene.idle(7);
        scene.world().modifyBlock(rotatedECD, s -> (class_2680)s.method_11657((class_2769)ChainDriveBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), true);
        scene.idle(40);
        scene.world().showSection(verticalShaft, class_2350.field_11033);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(util.grid().at(3, 3, 0));
        scene.idle(10);
        scene.overlay().showText(60).text("Any part of the row can be rotated by 90 degrees").placeNearTarget().pointAt(util.vector().centerOf(3, 2, 0));
        scene.markAsFinished();
    }

    public static void adjustableChainGearshift(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("chain_gearshift", "Controlling rotational speed with Chain Gearshifts");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 leverPos = util.grid().at(3, 1, 0);
        class_2338 eastDrive = util.grid().at(3, 1, 2);
        class_2338 eastGauge = eastDrive.method_10086(3);
        class_2338 middleGauge = eastGauge.method_10067().method_10074();
        class_2338 westGauge = eastGauge.method_10088(2).method_10087(2);
        ElementLink lever = scene.world().showIndependentSection(util.select().fromTo(leverPos, leverPos.method_10072()), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 4, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(eastDrive, eastDrive.method_10088(2)).add(util.select().position(eastDrive.method_10084())), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(60).text("Unpowered Chain Gearshifts behave exactly like Chain Drives").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(eastDrive, class_2350.field_11043));
        scene.idle(60);
        scene.world().showSection(util.select().fromTo(eastGauge, eastGauge.method_10074()), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(middleGauge, middleGauge.method_10074()), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(westGauge), class_2350.field_11033);
        scene.idle(5);
        for (class_2338 gauge : new class_2338[]{eastGauge, middleGauge, westGauge}) {
            scene.idle(5);
            scene.overlay().showText(50).sharedText(gauge == eastGauge ? "rpm16_source" : "rpm16").colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector().blockSurface(gauge, class_2350.field_11043));
        }
        scene.idle(60);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        scene.effects().indicateRedstone(leverPos);
        scene.world().modifyKineticSpeed(util.select().fromTo(westGauge.method_10074(), middleGauge), f -> Float.valueOf(2.0f * f.floatValue()));
        scene.idle(10);
        class_238 bb = new class_238(eastDrive);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, (Object)eastDrive, bb, 160);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.FAST, (Object)eastDrive.method_10067(), bb.method_989(-2.0, 0.0, 0.0).method_1012(0.9375, 0.0, 0.0), 160);
        scene.idle(20);
        scene.overlay().showText(80).text("When Powered, the speed transmitted to other Chain Drives in the row is doubled").attachKeyFrame().placeNearTarget().colored(PonderPalette.FAST).pointAt(util.vector().blockSurface(eastDrive.method_10088(2), class_2350.field_11039));
        scene.idle(80);
        for (class_2338 gauge : new class_2338[]{eastGauge, middleGauge, westGauge}) {
            scene.idle(5);
            scene.overlay().showText(70).sharedText(gauge == eastGauge ? "rpm16_source" : "rpm32").colored(gauge == eastGauge ? PonderPalette.MEDIUM : PonderPalette.FAST).placeNearTarget().pointAt(util.vector().blockSurface(gauge, class_2350.field_11043));
        }
        scene.idle(80);
        scene.world().hideSection(util.select().fromTo(eastDrive, eastDrive.method_10088(2)), class_2350.field_11035);
        scene.idle(15);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        Selection newDriveSelect = util.select().fromTo(eastDrive.method_10077(2), eastDrive.method_10077(2).method_10088(2));
        ElementLink drives = scene.world().showIndependentSection(newDriveSelect, class_2350.field_11043);
        scene.world().modifyKineticSpeed(util.select().fromTo(westGauge.method_10074(), middleGauge), f -> Float.valueOf(0.5f * f.floatValue()));
        scene.world().setKineticSpeed(newDriveSelect, -32.0f);
        scene.world().moveSection(drives, util.vector().of(0.0, 0.0, -2.0), 0);
        scene.world().moveSection(lever, util.vector().of(-2.0, 0.0, 0.0), 10);
        scene.idle(40);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(1)));
        scene.world().toggleRedstonePower(util.select().position(1, 1, 4));
        class_2338 analogPos = leverPos.method_10088(2);
        scene.effects().indicateRedstone(analogPos);
        scene.world().modifyKineticSpeed(util.select().position(westGauge), f -> Float.valueOf(0.5f * f.floatValue()));
        scene.idle(10);
        bb = new class_238(eastDrive);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.MEDIUM, (Object)eastDrive, bb.method_1012(-0.9375, 0.0, 0.0), 160);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.SLOW, (Object)eastDrive.method_10067(), bb.method_989(-2.0, 0.0, 0.0), 160);
        scene.idle(20);
        scene.overlay().showText(80).text("Whenever the Powered Gearshift is not at the source, its speed will be halved instead").attachKeyFrame().placeNearTarget().colored(PonderPalette.SLOW).pointAt(util.vector().blockSurface(eastDrive.method_10088(2), class_2350.field_11039));
        scene.idle(80);
        for (class_2338 gauge : new class_2338[]{eastGauge, middleGauge, westGauge}) {
            scene.idle(5);
            scene.overlay().showText(180).sharedText(gauge == westGauge ? "rpm8" : (gauge == eastGauge ? "rpm16_source" : "rpm16")).colored(gauge == westGauge ? PonderPalette.SLOW : PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector().blockSurface(gauge, class_2350.field_11043));
        }
        scene.idle(80);
        scene.overlay().showText(100).text("In both cases, Chain Drives in the row always run at 2x the speed of the Powered Gearshift").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(eastDrive.method_10088(2), class_2350.field_11039));
        scene.idle(100);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10077(2)));
        scene.world().toggleRedstonePower(util.select().position(1, 1, 4));
        scene.world().modifyKineticSpeed(util.select().position(westGauge), f -> Float.valueOf(2.0f * f.floatValue()));
        scene.world().hideIndependentSection(lever, class_2350.field_11036);
        scene.idle(15);
        scene.world().showSection(util.select().fromTo(analogPos, analogPos.method_10072()), class_2350.field_11033);
        scene.idle(15);
        scene.world().modifyBlockEntityNBT(util.select().position(analogPos), AnalogLeverBlockEntity.class, nbt -> nbt.method_10569("State", 8));
        scene.world().modifyBlock(analogPos.method_10072(), s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(8)), false);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 4));
        scene.world().modifyKineticSpeed(util.select().position(westGauge), f -> Float.valueOf(0.75f * f.floatValue()));
        scene.effects().indicateRedstone(analogPos);
        scene.idle(20);
        scene.overlay().showText(100).text("Using analog signals, the ratio can be adjusted more precisely between 1 and 2").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(eastDrive.method_10088(2), class_2350.field_11039));
        scene.idle(40);
        for (class_2338 gauge : new class_2338[]{eastGauge, middleGauge, westGauge}) {
            scene.idle(5);
            TextElementBuilder textBuilder = scene.overlay().showText(180).colored(gauge == westGauge ? PonderPalette.SLOW : PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector().blockSurface(gauge, class_2350.field_11043));
            if (gauge == westGauge) {
                textBuilder.text("12 RPM");
                continue;
            }
            textBuilder.sharedText(gauge == eastGauge ? "rpm16_source" : "rpm16");
        }
    }
}

