/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class JupiterConfigListWidget
extends ObjectSelectionList<ConfigEntry> {
    private final JupiterConfigListScreen screen;
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public JupiterConfigListWidget(JupiterConfigListScreen screen, Minecraft client, int width, int height, int y, int entryHeight) {
        super(client, width, height, y, entryHeight);
        this.screen = screen;
    }

    public void update() {
        this.entries.clear();
        ConfigManager.getInstance().getConfigs().forEach(x -> this.entries.add(new ConfigEntry(this.screen, (AbstractConfigContainer)x)));
        this.updateEntries();
    }

    protected int scrollBarX() {
        return super.scrollBarX() + 30;
    }

    private void updateEntries() {
        this.clearEntries();
        this.entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public boolean keyPressed(@NotNull KeyEvent event) {
        ConfigEntry entry = (ConfigEntry)this.getSelected();
        return entry != null && entry.keyPressed(event) || super.keyPressed(event);
    }

    public static class ConfigEntry
    extends ObjectSelectionList.Entry<ConfigEntry> {
        private final Minecraft client = Minecraft.getInstance();
        private final JupiterConfigListScreen screen;
        private final AbstractConfigContainer handler;

        public ConfigEntry(JupiterConfigListScreen screen, AbstractConfigContainer handler) {
            this.screen = screen;
            this.handler = handler;
        }

        public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            int x = this.getX();
            int y = this.getY();
            graphics.drawString(this.client.font, TextUtil.translatable(this.handler.getTitleNameKey(), new Object[0]), x + 32 + 3, y + 2, -1);
            graphics.drawString(this.client.font, this.handler.getConfigId().toString(), x + 32 + 3, y + 2 + 9, -8421505);
        }

        public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean doubleClicked) {
            this.screen.select(this);
            return false;
        }

        public AbstractConfigContainer getConfigContainer() {
            return this.handler;
        }

        @NotNull
        public Component getNarration() {
            return TextUtil.empty();
        }
    }
}

