package com.iafenvoy.jupiter.network;

//? >=1.20.5 {

import com.iafenvoy.jupiter.network.payload.ConfigErrorPayload;
import com.iafenvoy.jupiter.network.payload.ConfigRequestPayload;
import com.iafenvoy.jupiter.network.payload.ConfigSyncPayload;
//?}

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_370;

public class ClientConfigNetwork {
    private static final Map<class_2960, Consumer<class_2487>> CALLBACKS = new HashMap<>();

    public static void syncConfig(AbstractConfigContainer container) {
        syncConfig(container.getConfigId(), container::deserializeNbt);
    }

    @Comment("will pass null to nbt if not allowed")
    public static void syncConfig(class_2960 id, Consumer<class_2487> callback) {
        CALLBACKS.put(id, callback);
        //? >=1.20.5 {
        ClientNetworkHelper.INSTANCE.sendToServer(new ConfigRequestPayload(id));
         //?} else {
        /*ClientNetworkHelper.INSTANCE.sendToServer(NetworkConstants.CONFIG_REQUEST_C2S, ByteBufHelper.create().writeResourceLocation(id));
        *///?}
    }

    public static void init() {
        //? >=1.20.5 {
        ClientNetworkHelper.INSTANCE.registerReceiver(ConfigSyncPayload.TYPE, (client, payload) -> onConfigSync(payload.id(), payload.allow(), payload.compound()));
        ClientNetworkHelper.INSTANCE.registerReceiver(ConfigErrorPayload.TYPE, (minecraft, buf) -> onConfigError(minecraft));
        //?} else {
        /*ClientNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_S2C, (minecraft, buf) -> onConfigSync(buf.readResourceLocation(), buf.readBoolean(), buf.readNbt()));
        ClientNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_ERROR_S2C, (minecraft, buf) -> onConfigError(minecraft));
        *///?}
    }

    private static Runnable onConfigSync(class_2960 id, boolean allow, class_2487 data) {
        Consumer<class_2487> callback = CALLBACKS.get(id);
        if (callback == null) return null;
        if (allow) {
            return () -> callback.accept(data);
        } else
            return () -> callback.accept(null);
    }

    private static Runnable onConfigError(class_310 minecraft) {
        return () -> minecraft./*? >=1.21.2 {*//*getToastManager*//*?} else {*/method_1566/*?}*/().method_1999(new class_370(class_370./*? >=1.20.2 {*/class_9037/*?} else {*//*SystemToastIds*//*?}*/.field_47586, TextUtil.translatable("jupiter.toast.upload_config_error_title"), TextUtil.translatable("jupiter.toast.upload_config_error_content")));
    }
}
