package com.iafenvoy.jupiter.render;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public final class TitleStack {
    private static final class_2561 OMIT = TextUtil.literal("..."), SEPARATOR = TextUtil.literal(" -> ").method_27692(class_124.field_1080);
    private final class_327 font = class_310.method_1551().field_1772;
    private final List<class_2561> titles;
    private class_5250 cachedTitle = TextUtil.empty();

    private TitleStack(List<class_2561> titles) {
        this.titles = titles;
    }

    public TitleStack push(class_2561 title) {
        ImmutableList.Builder<class_2561> builder = ImmutableList.builder();
        builder.addAll(this.titles);
        builder.add(title);
        return new TitleStack(builder.build());
    }

    public static TitleStack create(class_2561 title) {
        return new TitleStack(List.of(title));
    }

    public void cacheTitle(int width) {
        if (this.titles.isEmpty()) return;
        class_5250 part = TextUtil.empty();
        this.cachedTitle = TextUtil.empty();
        for (int i = this.titles.size() - 1; i >= 0; i--) {
            boolean first = i == this.titles.size() - 1;
            if (first) {
                part.method_10852(this.titles.get(i));
                if (i > 0) this.cachedTitle.method_10852(OMIT).method_10852(SEPARATOR);
                this.cachedTitle.method_10852(part);
            } else {
                part = TextUtil.empty().method_10852(this.titles.get(i)).method_10852(SEPARATOR).method_10852(part);
                class_5250 component = TextUtil.empty();
                if (i > 0) component.method_10852(OMIT).method_10852(SEPARATOR);
                component.method_10852(part);
                if (this.font.method_27525(component) > width) break;
                this.cachedTitle = component;
            }
        }
    }

    public class_2561 getTitle() {
        return this.cachedTitle;
    }
}
