/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.container;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public abstract class FileConfigContainer
extends AbstractConfigContainer {
    protected final String path;

    public FileConfigContainer(ResourceLocation id, String titleNameKey, String path) {
        super(id, titleNameKey);
        this.path = path;
    }

    @Override
    public String getPath() {
        return Path.of(this.path, new String[0]).getFileName().toString();
    }

    @Override
    public void load() {
        try {
            this.deserialize(FileUtils.readFileToString((File)new File(this.path), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            Jupiter.LOGGER.error("Failed to load config: {}", (Object)this.path, (Object)e);
            this.save();
        }
    }

    @Override
    public void save() {
        try {
            FileUtils.write((File)new File(this.path), (CharSequence)this.serialize(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Jupiter.LOGGER.error("Failed to save config: {}", (Object)this.path, (Object)e);
        }
    }

    @Override
    public ConfigSource getSource() {
        return ConfigSource.JUPITER;
    }
}

