/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.entry.LongEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import java.util.List;

public class ListLongEntry
extends ListBaseEntry<Long> {
    public ListLongEntry(String nameKey, List<Long> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Long> getValueCodec() {
        return Codec.LONG;
    }

    @Override
    public IConfigEntry<Long> newSingleInstance(Long value, final int index, final Runnable reload) {
        return new LongEntry(this.nameKey, value){

            @Override
            public void reset() {
                ((List)ListLongEntry.this.getValue()).remove(index);
                reload.run();
            }

            @Override
            public void setValue(Long value) {
                super.setValue(value);
                ((List)ListLongEntry.this.getValue()).set(index, value);
            }
        };
    }

    @Override
    public Long newValue() {
        return 0L;
    }

    @Override
    public ConfigType<List<Long>> getType() {
        return ConfigTypes.LIST_LONG;
    }

    @Override
    public IConfigEntry<List<Long>> newInstance() {
        return new ListLongEntry(this.nameKey, (List)this.defaultValue).visible(this.visible).json(this.jsonKey);
    }
}

