/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter._loader.forge;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.compat.ExtraConfigManager;
import com.iafenvoy.jupiter.internal.ConfigButtonReplaceStrategy;
import com.iafenvoy.jupiter.internal.JupiterSettings;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class JupiterForgeClient {
    @SubscribeEvent
    public static void processClient(FMLClientSetupEvent event) {
        Jupiter.processClient();
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((client, screen) -> new JupiterConfigListScreen((Screen)screen)));
        ExtraConfigManager.registerScanCallback(JupiterForgeClient::fillExtensionPoints);
    }

    @SubscribeEvent
    public static void registerClientListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ConfigManager.getInstance());
    }

    public static void fillExtensionPoints() {
        ConfigButtonReplaceStrategy strategy = (ConfigButtonReplaceStrategy)((Object)JupiterSettings.INSTANCE.general.configButtonReplacement.getValue());
        if (strategy == ConfigButtonReplaceStrategy.NEVER) {
            return;
        }
        for (String id : ExtraConfigManager.getProvidedMods()) {
            Optional optional = ModList.get().getModContainerById(id);
            if (optional.isEmpty()) continue;
            ModContainer container = (ModContainer)optional.get();
            if (strategy == ConfigButtonReplaceStrategy.UNAVAILABLE_ONLY && container.getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).isPresent()) continue;
            container.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((c, parent) -> ExtraConfigManager.getScreen(id).apply((Screen)parent)));
        }
    }
}

