/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.interfaces.RangeConfigEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import net.minecraft.network.chat.Component;

public class DoubleEntry
extends BaseEntry<Double>
implements RangeConfigEntry<Double> {
    private final double minValue;
    private final double maxValue;
    private boolean useSlider = false;

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public DoubleEntry(String nameKey, double defaultValue) {
        this(nameKey, defaultValue, -2.147483648E9, 2.147483647E9);
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public DoubleEntry(String nameKey, double defaultValue, double minValue, double maxValue) {
        super(nameKey, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected DoubleEntry(Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    public DoubleEntry slider() {
        if (-2.147483648E9 < this.minValue && this.maxValue < 2.147483647E9) {
            this.useSlider = true;
        }
        return this;
    }

    @Override
    public ConfigType<Double> getType() {
        return ConfigTypes.DOUBLE;
    }

    @Override
    public IConfigEntry<Double> newInstance() {
        return new Builder(this).build();
    }

    @Override
    public Codec<Double> getCodec() {
        return Codec.doubleRange((double)this.minValue, (double)this.maxValue);
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean useSlider() {
        return this.useSlider;
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public void setValueFromString(String s) {
        double d = Double.parseDouble(s);
        if (d < this.minValue || d > this.maxValue) {
            throw new IllegalArgumentException();
        }
        this.setValue(d);
    }

    public static Builder builder(Component name, double defaultValue) {
        return new Builder(name, defaultValue);
    }

    public static Builder builder(String nameKey, double defaultValue) {
        return new Builder(nameKey, defaultValue);
    }

    public static class Builder
    extends BaseEntry.Builder<Double, DoubleEntry, Builder> {
        protected double minValue = Double.MIN_VALUE;
        protected double maxValue = Double.MAX_VALUE;

        public Builder(Component name, double defaultValue) {
            super(name, Double.valueOf(defaultValue));
        }

        public Builder(String nameKey, double defaultValue) {
            super(nameKey, Double.valueOf(defaultValue));
        }

        public Builder(DoubleEntry parent) {
            super(parent);
            this.minValue = parent.minValue;
            this.maxValue = parent.maxValue;
        }

        public Builder min(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder max(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder range(double min, double max) {
            this.min(min);
            this.max(max);
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        protected DoubleEntry buildInternal() {
            return new DoubleEntry(this);
        }
    }
}

