/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.JupiterRenderContext;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    private final TitleStack titleStack;
    private final ResourceLocation id;
    private final boolean client;
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList();
    protected final VerticalScrollBar entryScrollBar = new VerticalScrollBar();
    protected List<IConfigEntry<?>> entries = List.of();
    protected int topBorder = 30;
    private int configPerPage;
    private int textMaxLength;

    public ConfigListScreen(Screen parent, TitleStack titleStack, ResourceLocation id, List<IConfigEntry<?>> entries, boolean client) {
        this(parent, titleStack, id, client);
        this.entries = entries;
    }

    public ConfigListScreen(Screen parent, TitleStack titleStack, ResourceLocation id, boolean client) {
        super((Component)TextUtil.empty());
        this.parent = parent;
        this.titleStack = titleStack;
        this.id = id;
        this.client = client;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.titleStack.cacheTitle(this.f_96543_ - this.f_96547_.m_92895_(this.getCurrentEditText()) - 70);
        this.m_142416_((GuiEventListener)JupiterScreen.createButton(10, 5, 20, 20, (Component)TextUtil.literal("<"), button -> this.m_7379_()));
        this.calculateMaxEntries();
        this.textMaxLength = Mth.m_14045_((int)(this.entries.stream().filter(x -> x instanceof BaseEntry).map(IConfigEntry::getName).filter(Objects::nonNull).map(t -> this.f_96547_.m_92852_((FormattedText)t)).max(Comparator.naturalOrder()).orElse(0) + 30), (int)(this.f_96543_ / 2), (int)(this.f_96543_ - 150));
        this.configWidgets.clear();
        this.configWidgets.addAll(this.entries.stream().map(c -> WidgetBuilderManager.get(new ConfigMetaProvider.SimpleProvider(this.id, "%ERROR%", this.client), c)).toList());
        this.configWidgets.forEach(b -> b.addElements(new WidgetBuilder.Context(this, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.titleStack), this.textMaxLength, 0, Math.max(10, this.f_96543_ - this.textMaxLength - 30), 20));
        this.updateEntryPos();
    }

    protected void rebuildWidgets() {
        this.m_169413_();
        this.m_7856_();
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.calculateMaxEntries();
        this.updateEntryPos();
    }

    @NotNull
    public Component m_96636_() {
        return this.titleStack.getTitle();
    }

    public void calculateMaxEntries() {
        this.configPerPage = Math.max(0, (this.f_96544_ - this.topBorder - 10) / 25);
        this.entryScrollBar.setMaxValue(Math.max(0, this.entries.size() - this.configPerPage));
    }

    public void updateEntryPos() {
        int i;
        int top = this.entryScrollBar.getValue();
        for (i = 0; i < top && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(true, this.topBorder + 5 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
    }

    @Nullable
    public IConfigEntry<?> getMouseOverEntry(int mouseX, int mouseY) {
        return this.configWidgets.stream().filter(widget -> widget.isMouseOver(mouseX, mouseY)).findFirst().map(WidgetBuilder::getConfig).orElse(null);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (super.m_6050_(mouseX, mouseY, scrollY)) {
            return true;
        }
        if (mouseY >= (double)this.topBorder) {
            this.entryScrollBar.setValue(this.entryScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
            this.updateEntryPos();
            return true;
        }
        return false;
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        IConfigEntry<?> entry;
        this.m_7333_(graphics);
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
        String currentText = this.getCurrentEditText();
        int textWidth = this.f_96547_.m_92895_(currentText);
        JupiterRenderContext context = JupiterRenderContext.wrapPoseStack(graphics);
        context.drawString(this.f_96547_, this.m_96636_(), 40, 10, -1);
        context.drawString(this.f_96547_, currentText, this.f_96543_ - textWidth - 10, 10, -1);
        this.entryScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.f_96543_ - 18, this.topBorder, 8, this.f_96544_ - this.topBorder - 10, (this.configPerPage + this.entryScrollBar.getMaxValue()) * 25);
        if (this.entryScrollBar.isDragging()) {
            this.updateEntryPos();
        }
        if ((entry = this.getMouseOverEntry(mouseX, mouseY)) != null && entry.getTooltip() != null) {
            this.m_96602_(graphics, entry.getTooltip(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.entryScrollBar.wasMouseOver()) {
            this.entryScrollBar.setIsDragging(true);
            this.updateEntryPos();
            return true;
        }
        boolean b = super.m_6375_(mouseX, mouseY, button);
        if (!b) {
            this.m_7522_(null);
        }
        return b;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.entryScrollBar.setIsDragging(false);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected String getCurrentEditText() {
        if (this.client) {
            return I18n.m_118938_((String)"jupiter.screen.current_modifying_client", (Object[])new Object[0]);
        }
        if (this.entries instanceof RemoteConfigWrapper) {
            return I18n.m_118938_((String)"jupiter.screen.current_modifying_dedicate_server", (Object[])new Object[0]);
        }
        return I18n.m_118938_((String)"jupiter.screen.current_modifying_local_server", (Object[])new Object[0]);
    }
}

