/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractListDialog<T, S>
extends Dialog<T> {
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<S>> widgets = new ArrayList<WidgetBuilder<S>>();
    private int configPerPage;

    protected AbstractListDialog(Screen parent, TitleStack titleStack, ConfigMetaProvider provider, IConfigEntry<T> entry) {
        super(parent, titleStack, provider, entry);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)JupiterScreen.createButton(10, 5, 20, 20, (Component)TextUtil.literal("<"), button -> this.m_7379_()));
        this.m_142416_((GuiEventListener)JupiterScreen.createButton(this.f_96543_ - 80, 5, 20, 20, (Component)TextUtil.literal("+"), button -> {
            this.addNewValue();
            this.rebuildWidgets();
        }));
        this.calculateMaxItems();
        this.widgets.clear();
        List<S> values = this.getValues().stream().toList();
        for (int i = 0; i < values.size(); ++i) {
            WidgetBuilder<S> widget = WidgetBuilderManager.get(this.provider, this.newSingleInstance(values.get(i), i, this::rebuildWidgets));
            this.widgets.add(widget);
            widget.addDialogElements(new WidgetBuilder.Context(this, x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
            }, this.titleStack), i + ":", 40, 0, Math.max(10, this.f_96543_ - 70), 20);
        }
        this.updateItemPos();
    }

    protected abstract void addNewValue();

    protected abstract Collection<S> getValues();

    protected abstract IConfigEntry<S> newSingleInstance(S var1, int var2, Runnable var3);

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.f_96544_ - 30) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, this.getValues().size() - this.configPerPage));
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        Collection<S> entries = this.getValues();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (super.m_6050_(mouseX, mouseY, scrollY)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.f_96543_ - 18, 30, 8, this.f_96544_ - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.m_6375_(mouseX, mouseY, button);
        if (!b) {
            this.m_7522_(null);
        }
        return b;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

