package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import com.iafenvoy.jupiter.util.TextUtil;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ConfigContainerScreen extends ConfigListScreen {
    private final class_437 parent;
    protected final AbstractConfigContainer container;
    protected final List<TabButton> groupButtons = new ArrayList<>();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;

    public ConfigContainerScreen(class_437 parent, AbstractConfigContainer container, boolean client) {
        super(parent, TitleStack.create(TextUtil.translatable(container.getTitleNameKey())), container.getConfigId(), client);
        this.parent = parent;
        this.container = container;
        this.currentGroup = container.getConfigTabs().isEmpty() ? ConfigGroup.EMPTY : container.getConfigTabs()/*? >=1.20.5 {*/.getFirst()/*?} else {*//*.get(0)*//*?}*/;
        this.topBorder = 60;
    }

    @Override
    protected void method_25426() {
        this.entries = this.currentGroup.getConfigs();
        super.method_25426();
        int x = 10, y = 27;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.container.getConfigTabs();
        for (int i = 0; i < configTabs.size(); i++) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = this.method_37063(new TabButton(category, x, y, this.field_22793.method_1727(class_1074.method_4662(category.getTranslateKey())) + 10, ENTRY_HEIGHT, button -> {
                this.currentTab = this.container.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.method_41843();
            }));
            tabButton.field_22763 = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.method_25368() + 2;
        }
        x += 10;
        this.groupScrollBar.setMaxValue(Math.max(0, x - this.field_22789));
        this.updateTabPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons)
            button.updatePos(this.groupScrollBar.getValue());
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY,/*? >=1.20.2 {*/double scrollX,/*?}*/ double scrollY) {
        if (super.method_25401(mouseX, mouseY,/*? >=1.20.2 {*/scrollX,/*?}*/ scrollY)) return true;
        if (mouseX >= 10 && mouseX <= this.field_22789 - 20 && mouseY >= 25 && mouseY <= 60) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (scrollY > 0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        return false;
    }

    @Override
    public void method_25419() {
        this.container.onConfigsChanged();
        assert this.field_22787 != null;
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void method_25394(@NotNull /*? >=1.20 {*/class_332/*?} else {*//*PoseStack*//*?}*/ graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.groupScrollBar.render(graphics, mouseX, mouseY, partialTicks, 10, 50, this.field_22789 - 20, 8, this.field_22789 + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) this.updateTabPos();
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        return super.method_25402(/*? >=1.21.9 {*//*event, isDoubleClick*//*?} else {*/mouseX, mouseY, button/*?}*/);
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseReleased(MouseButtonEvent event) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0) this.groupScrollBar.setIsDragging(false);
        return super.method_25406(/*? >=1.21.9 {*//*event*//*?} else {*/mouseX, mouseY, button/*?}*/);
    }

    public static class TabButton extends class_4185 {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, TextUtil.translatable(group.getTranslateKey()), button -> listener.accept((TabButton) button)/*? >=1.19.3 {*/, field_40754/*?}*/);
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this./*? >= 1.19.3 {*/method_46421/*?} else {*//*x =*//*?}*/(this.baseX - offsetX);
        }
    }
}
